<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\VilleController;
use App\Http\Controllers\TailleController;
use App\Http\Controllers\CouleurController;
use App\Http\Controllers\ProduitController;
use App\Http\Controllers\MouvementtransferController;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});
Route::get('/test', [App\Http\Controllers\Controller::class, 'test']);
Auth::routes();




Route::resource('couleurs', CouleurController::class)->except(['create','edit','show']);

Route::resource('tailles', TailleController::class)->except(['create','edit','show']);

Route::get('/gethystorique/{client}/{produit}', [App\Http\Controllers\HystoriqprixController::class, 'gethystorique']);
Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');

Route::get('/categorie1', [App\Http\Controllers\CategorieController::class, 'create']);
Route::post('/ianactive/{id}', [App\Http\Controllers\ActivebuttonController::class, 'ianactive']);
Route::get('/topcat1', [App\Http\Controllers\TopcatController::class, 'create']);
Route::post('/addtopcat', [App\Http\Controllers\TopcatController::class, 'store']);
Route::post('/addbanque', [App\Http\Controllers\BanqueController::class, 'store']);

Route::post('/test2', [App\Http\Controllers\TestController::class, 'store']);
Route::get('/topcatsup/{id}', [App\Http\Controllers\TopcatController::class, 'destroy']);
Route::post('/modiftopcat/{id}', [App\Http\Controllers\TopcatController::class, 'update']);
Route::get('/searchecat', [App\Http\Controllers\TopcatController::class,'searchecat'])->name('searchecat');


Route::post('/modiflieustock/{id}', [App\Http\Controllers\LieustockController::class, 'update']);

Route::post('/modifdepense/{id}', [App\Http\Controllers\DepenseController::class, 'update']);
Route::get('/suplieu/{id}', [App\Http\Controllers\LieustockController::class, 'destroy']);
Route::get('/supdepense/{id}', [App\Http\Controllers\DepenseController::class, 'destroy']);
Route::get('recherche-depense', [App\Http\Controllers\DepenseController::class, 'rechercheDate'])->name('recherche.depense');




Route::get('/supachat/{id}', [App\Http\Controllers\AchatController::class, 'destroy']);
Route::get('/cherchefacturachat', [App\Http\Controllers\AchatController::class, 'cherchefacturachat']);




Route::get('/charete', [App\Http\Controllers\VenteController::class, 'charete'])->name('ventes.index');
Route::get('/supavoir/{id}', [App\Http\Controllers\AvoirController::class, 'destroy']);
Route::get('/enatted_toconfirm/{id}', [App\Http\Controllers\VenteController::class, 'enatted_toconfirm']);

Route::get('/destroy_enattend/{id}', [App\Http\Controllers\VenteController::class, 'destroy_enattend']);
//
Route::get('/supdevis/{id}', [App\Http\Controllers\DevisController::class, 'destroy']);
Route::get('/supcommande/{id}', [App\Http\Controllers\BoncommandeController::class, 'destroy']);

Route::post('/addcatdepense', [App\Http\Controllers\CatdepenseController::class, 'store']);
Route::post('/modifcatdepense/{id}', [App\Http\Controllers\CatdepenseController::class, 'update']);
Route::get('/catdepense', [App\Http\Controllers\CatdepenseController::class, 'index']);
Route::get('/supcatdepense/{id}', [App\Http\Controllers\CatdepenseController::class, 'destroy']);

Route::get('/cheque', [App\Http\Controllers\ChequeController::class, 'cheque']);
Route::get('/info', [App\Http\Controllers\InfoController::class, 'info']);
Route::post('/addinfo', [App\Http\Controllers\InfoController::class, 'store']);
Route::get('/stock', [App\Http\Controllers\StockController::class, 'index']);
Route::get('/fournisseurs1', [App\Http\Controllers\FournisseurController::class, 'index']);
Route::get('/fournisseurs', [App\Http\Controllers\FournisseurController::class, 'fournisseurs']);
Route::get('/clients1', [App\Http\Controllers\ClientController::class, 'index']);
Route::get('/cientsup/{id}', [App\Http\Controllers\ClientController::class, 'destroy']);
Route::get('/fournissersup/{id}', [App\Http\Controllers\FournisseurController::class, 'destroy']);

Route::post('/modiif_reglement/{id}', [App\Http\Controllers\ReglementClController::class, 'modiif_reglement']);



Route::post('/liquidation/{id}', [App\Http\Controllers\ClientController::class, 'liquidation']);
Route::get('/blenatted', [App\Http\Controllers\VenteController::class, 'blenatted']);
Route::get('/caissebl', [App\Http\Controllers\VenteController::class, 'caissebl']);
Route::get('/cherchcaissebl', [App\Http\Controllers\VenteController::class, 'cherchcaissebl']);


Route::get('/blconfirme', [App\Http\Controllers\VenteController::class, 'blconfirme']);
Route::get('/modifevente/{id}', [App\Http\Controllers\VenteController::class, 'modifevente']);

Route::post('/modif_avoir', [App\Http\Controllers\AvoirController::class, 'modif_avoir']);


Route::get('/modifevente2', [App\Http\Controllers\VenteController::class, 'modifevente2']);
Route::post('/reglevente', [App\Http\Controllers\VenteController::class, 'reglevente']);

Route::get('/client_errecouvrable', [App\Http\Controllers\ClientController::class, 'irrecouvrableclients']);

Route::get('/entrer/{id}', [App\Http\Controllers\StockController::class, 'entrer']);
Route::get('/sortie/{id}', [App\Http\Controllers\StockController::class, 'sortie']);
Route::get('/vente', [App\Http\Controllers\VenteController::class, 'index']);
Route::get('/achat', [App\Http\Controllers\AchatController::class, 'index']);

Route::get('/commande', [App\Http\Controllers\BoncommandeController::class, 'index']);
Route::get('/facturboncommande', [App\Http\Controllers\BoncommandeController::class, 'facturboncommande']);
Route::get('/cherchefacturcommande', [App\Http\Controllers\BoncommandeController::class, 'cherchefacturcommande']);




Route::get('/blurgent', [App\Http\Controllers\VenteController::class, 'blurgent']);
Route::get('/facturvente', [App\Http\Controllers\VenteController::class, 'facturvente']);
Route::get('/bonlivraison', [App\Http\Controllers\VenteController::class, 'bonlivraison']);
Route::get('/detaillefacturvente/{id}', [App\Http\Controllers\VenteController::class, 'detaillefacturvente']);
Route::get('/reglementclient', [App\Http\Controllers\VenteController::class, 'reglementclient']);
Route::get('/reglementclient_all', [App\Http\Controllers\VenteController::class, 'reglementclient_all']);
Route::get('/modifevente', [App\Http\Controllers\VenteController::class, 'modifevente']);

Route::get('/facturachat', [App\Http\Controllers\AchatController::class, 'facturachat']);
Route::get('/devis', [App\Http\Controllers\DevisController::class, 'index']);
Route::get('/facturdevis', [App\Http\Controllers\DevisController::class, 'facturdevis']);
Route::get('/cherchefacturdevis', [App\Http\Controllers\DevisController::class, 'cherchefacturdevis']);

Route::get('/createproduit', [App\Http\Controllers\ProduitController::class, 'createpageproduit']);
//Route::get('/produitparcat/{id}', [App\Http\Controllers\ProduitController::class, 'produitparcat']);
Route::get('/document', [App\Http\Controllers\ProduitController::class, 'document']);
Route::get('/comptabilite', [App\Http\Controllers\ProduitController::class, 'comptabilite']);
Route::get('/ventepdf/{id}', [App\Http\Controllers\PdfController::class, 'ventepdf']);
Route::get('/achatpdf/{id}', [App\Http\Controllers\PdfController::class, 'achatpdf']);
Route::get('/boncommandepdf/{id}', [App\Http\Controllers\PdfController::class, 'comandepdf']);

Route::get('/avoirpdf/{id}', [App\Http\Controllers\PdfController::class, 'avoirpdf']);
Route::get('/enattendpdf/{id}', [App\Http\Controllers\PdfController::class, 'enattendpdf']);

Route::get('/searchinv', [App\Http\Controllers\ProduitController::class, 'searchinv']);
Route::get('/chercheproduit', [App\Http\Controllers\ProduitController::class, 'chercheproduit']);
Route::get('/searchepc/{id}', [App\Http\Controllers\ProduitController::class, 'searchepc']);

Route::get('/produits/recherche', [App\Http\Controllers\ProduitController::class, 'search'])->name('produits.search');
Route::get('/produits/alert', [App\Http\Controllers\ProduitController::class, 'searchealert'])->name('produits.alert');

Route::get('/lastid', [App\Http\Controllers\ProduitController::class, 'lastid']);

Route::get('/modifrix', [App\Http\Controllers\ProduitController::class, 'modifrix']);
Route::post('/modifrixstor', [App\Http\Controllers\ProduitController::class, 'modifrixstor']);

Route::get('/ventepdf/{id}', [App\Http\Controllers\PdfController::class, 'ventepdf']);
Route::get('/ventepdfsansentete/{id}', [App\Http\Controllers\PdfController::class, 'ventepdfsansentete']);




Route::get('/bonlivraisonpdf/{id}', [App\Http\Controllers\PdfController::class, 'bonlivraisonpdf'])->name( 'bonlivraisonpdf');
Route::get('/devispdf/{id}', [App\Http\Controllers\PdfController::class, 'devispdf']);






//Route::get('/chart', [App\Http\Controllers\ChartController::class, 'ventesMensuelles']);
Route::get('/chart', [App\Http\Controllers\ChartController::class, 'chart']);

Route::get('/test', [App\Http\Controllers\BonlivraisonController::class, 'test']);

//json
Route::get('/produits', [App\Http\Controllers\ProduitController::class, 'produits'])->name('produits.index');
//json
Route::get('/codebar', [App\Http\Controllers\ProduitController::class, 'codebar']);
Route::get('/modepayements', [App\Http\Controllers\ModepayementController::class, 'index']);
Route::get('/produitbyid/{id}', [App\Http\Controllers\ProduitController::class, 'produitbyid']);
Route::get('/getproduitbycat/{id}', [App\Http\Controllers\ProduitController::class, 'getproduitbycat']);


Route::get('/date_client/{id}', [App\Http\Controllers\ClientController::class, 'date_client']);
Route::get('/date_vente', [App\Http\Controllers\VenteController::class, 'date_vente']);
Route::get('/date', [App\Http\Controllers\ClientController::class, 'date']);

Route::get('/detaille_client/{id}', [App\Http\Controllers\ClientController::class, 'detaille_client']);
Route::get('/clients', [App\Http\Controllers\ClientController::class, 'clients']);
Route::get('/clientbyid/{id}', [App\Http\Controllers\ClientController::class, 'clientbyid']);
Route::post('/modifclient/{id}', [App\Http\Controllers\ClientController::class, 'modifclient']);
Route::post('/modiffacture/{id}', [App\Http\Controllers\ClientController::class, 'modiffacture']);

Route::get('/reglementt', [App\Http\Controllers\ReglementClController::class, 'index']);
Route::get('/fournisseurs', [App\Http\Controllers\FournisseurController::class, 'fournisseurs']);
Route::get('/fournisseurbyid/{id}', [App\Http\Controllers\FournisseurController::class, 'fournisseurbyid']);



Route::get('/lieustock', [App\Http\Controllers\LieustockController::class, 'index']);
Route::post('/addlieustock', [App\Http\Controllers\LieustockController::class, 'store']);

Route::get('/categorie', [App\Http\Controllers\CategorieController::class, 'categorie']);
Route::post('/addcategorie', [App\Http\Controllers\CategorieController::class, 'store']);


Route::get('/depense', [App\Http\Controllers\DepenseController::class, 'index']);
Route::get('/inventair', [App\Http\Controllers\ProduitController::class, 'inventair']);
Route::get('/produit', [App\Http\Controllers\ProduitController::class, 'index']);
Route::get('/detaille/{id}', [App\Http\Controllers\ProduitController::class, 'show']);

Route::get('/detaille/{id}', [App\Http\Controllers\ProduitController::class, 'show']);
Route::get('/deleteproduit/{id}', [App\Http\Controllers\ProduitController::class, 'destroy']);
Route::post('/addproduit/{id}', [App\Http\Controllers\ProduitController::class, 'store']);
Route::post('/addproduit2', [App\Http\Controllers\ProduitController::class, 'addproduit2']);
Route::get('/alert', [App\Http\Controllers\ProduitController::class, 'alert']);

Route::post('/adddeense', [App\Http\Controllers\DepenseController::class, 'store']);
Route::post('/updatproduit/{id}', [App\Http\Controllers\ProduitController::class, 'updatproduit']);
Route::post('/inventairupdat/{id}', [App\Http\Controllers\ProduitController::class, 'inventairupdat']);

Route::post('/qtyupdat/{id}', [App\Http\Controllers\ProduitController::class, 'qtyupdat']);

Route::post('/mdiflientlient/{id}', [App\Http\Controllers\ClientController::class, 'update']);
Route::post('/mdiffr/{id}', [App\Http\Controllers\FournisseurController::class, 'update']);
Route::post('/addstock', [App\Http\Controllers\StockController::class, 'store']);
Route::post('/addfournisseur', [App\Http\Controllers\FournisseurController::class, 'store']);
Route::post('/addclient', [App\Http\Controllers\ClientController::class, 'store']);
//Route::post('/addvente', [App\Http\Controllers\VenteController::class, 'store']);
Route::post('/modifier_vente/{id}', [App\Http\Controllers\VenteController::class, 'modifier_vente']);
Route::post('/modifier_avoir/{id}', [App\Http\Controllers\AvoirController::class, 'modifier_avoir']);

Route::post('/modifier_achat/{id}', [App\Http\Controllers\AchatController::class, 'modifier_achat']);

Route::post('/newavoir', [App\Http\Controllers\AvoirController::class, 'store']);
Route::get('/avoir', [App\Http\Controllers\AvoirController::class, 'avoir']);


Route::post('/newdevis', [App\Http\Controllers\DevisController::class, 'store']);
Route::post('/newcommande', [App\Http\Controllers\BoncommandeController::class, 'store']);
Route::get('/facture_avoir', [App\Http\Controllers\AvoirController::class, 'facture_avoir']);


Route::get('/cherchefacturavoir', [App\Http\Controllers\AvoirController::class, 'cherchefacturavoir']);

Route::post('/addachat', [App\Http\Controllers\AchatController::class, 'addachat']);
Route::post('/modif_achat', [App\Http\Controllers\AchatController::class, 'modif_achat']);
Route::post('/addachat2', [App\Http\Controllers\AchatController::class, 'storetest']);
Route::get('/all_ventes', [App\Http\Controllers\VenteController::class, 'all_ventes']);

Route::post('/deletevente/{id}', [App\Http\Controllers\VenteController::class, 'destroy']);
Route::delete('/deletelignevente/{id}', [App\Http\Controllers\VenteController::class, 'deletelignevente']);

Route::get('/deletenttend/{id}', [App\Http\Controllers\EnattendController::class, 'deletenttend']);

Route::delete('/deletligneachat/{id}', [App\Http\Controllers\AchatController::class, 'deletligneachat']);
Route::post('/addachat', [App\Http\Controllers\AchatController::class, 'store']);
Route::post('/adddevis', [App\Http\Controllers\DevisController::class, 'store']);
Route::post('/addboncommande', [App\Http\Controllers\BoncommandeController::class, 'store']);

Route::get('/caisse', [App\Http\Controllers\CaisseController::class, 'index']);
//admindash



Route::get('/dashboarduser', [App\Http\Controllers\HomeController::class, 'dashboarduser'])->name( 'dashboarduser')->middleware('role:user');
Route::get('/dashboard', [App\Http\Controllers\HomeController::class, 'dash'])->name( 'dashadmin')->middleware('role:admin');



Route::get('/users', [App\Http\Controllers\HomeController::class, 'roles'])->name('users.index');
Route::put('/users/{id}/roles', [App\Http\Controllers\HomeController::class, 'updateRoles'])->name('users.updateRoles');

Route::get('/info', [App\Http\Controllers\InfoController::class, 'info']);
Route::post('/addinfo', [App\Http\Controllers\InfoController::class, 'store']);
Route::delete('/users/{id}', [App\Http\Controllers\UserController::class, 'destroy'])->name('users.destroy');

Route::get('/villes', [VilleController::class, 'index'])->name('villes.index');
Route::post('/villes', [VilleController::class, 'store'])->name('villes.store');
Route::put('/villes/{id}', [VilleController::class, 'update'])->name('villes.update');
Route::delete('/villes/{id}', [VilleController::class, 'destroy'])->name('villes.destroy');





Route::get('/produitparcat/{lieustock_id}', [App\Http\Controllers\ProduitController::class, 'produitparcat'])->name('produit.par.cat');




// Liste produits par stock
Route::get('produits/stock/{lieustock_id}', [ProduitController::class, 'produitparcat'])->name('produit.parcat');

// Voir couleurs d'un produit filtré par stock
Route::get('produit/{produit_id}/stock/{lieustock_id}/couleurs', [ProduitController::class, 'couleur'])->name('produit.couleur');

// Voir tailles d'une couleur filtrée par stock
Route::get('produit/{produit_id}/couleur/{couleur_id}/stock/{lieustock_id}/tailles', [ProduitController::class, 'taille'])->name('produit.taille');

// Transférer qty vers un autre stock
Route::post('produit/transfer/{produit_variable_id}', [ProduitController::class, 'transfer'])->name('produit.transfer');
// Transférer qty vers un autre stock

Route::post('/produit/transfer/{id}', [ProduitController::class, 'transfer'])->name('produit.transfer');
// web.php
Route::post('/produit/{produit_id}/store-couleur-taille', [ProduitController::class, 'storeCouleurTaille'])
    ->name('produit.storeCouleurTaille');

Route::get('/admin/produit/create', [ProduitController::class, 'create'])->name('admin.produit.create');
Route::post('/admin/produit/store', [ProduitController::class, 'store'])->name('admin.produit.store');
Route::get('/produits/filter', [ProduitController::class, 'filter'])->name('admin.produit.filter');
Route::get('/produits/pdf', [App\Http\Controllers\PdfController::class, 'produitsPdf'])->name('admin.produit.pdf');
Route::get('/produits/testpdf', [ProduitController::class, 'testProduitsPdf']);

Route::get('/mouvements-transfers', [MouvementtransferController::class, 'index'])->name('mouvements.index');