@extends('layouts.appadmin')

@section('content')
<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">

            @if(session('success'))
                <div class="alert alert-success">
                    {{ session('success') }}
                </div>
            @endif

            <h3 class="mb-4">Ajouter une ville</h3>
            <form action="{{ route('villes.store') }}" method="POST" class="mb-5">
                @csrf
                <div class="input-group">
                    <input type="text" name="nom" class="form-control" placeholder="Nom de la ville" required>
                    <button type="submit" class="btn btn-primary">Ajouter</button>
                </div>
            </form>

            <h3 class="mb-3">Liste des villes</h3>
            <table class="table table-bordered table-hover">
                <thead class="table-dark">
                    <tr>
                        <th>ID</th>
                        <th>Nom</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($villes as $ville)
                        <tr>
                            <td>{{ $ville->id }}</td>
                            <td>
                                <form action="{{ route('villes.update', $ville->id) }}" method="POST" class="d-flex">
                                    @csrf
                                    @method('PUT')
                                    <input type="text" name="nom" value="{{ $ville->ville }}" class="form-control me-2" required>
                                    <button type="submit" class="btn btn-warning btn-sm">Modifier</button>
                                </form>
                            </td>
                            <td>
                                <form action="{{ route('villes.destroy', $ville->id) }}" method="POST" onsubmit="return confirm('Supprimer cette ville ?')">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-danger btn-sm">Supprimer</button>
                                </form>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>

        </div>
    </div>
</div>
@endsection
