@extends('layouts.appadmin')

@section('content')
  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-12">
          
            <h3 class="font-weight-bold">Gestion des Tailles</h3>

   
    {{-- Messages --}}
    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    {{-- Ajouter Taille --}}
    <form action="{{ route('tailles.store') }}" method="POST" class="d-flex mb-4">
        @csrf
        <input type="text" name="taille" class="form-control me-2" placeholder="Nouvelle taille" required>
        <button class="btn btn-primary">Ajouter</button>
    </form>

    {{-- Liste des tailles --}}
    <table class="table table-bordered">
        <thead>
            <tr>
                <th>ID</th>
                <th>Taille</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
        @foreach($tailles as $taille)
            <tr>
                <td>{{ $taille->id }}</td>
                <td>
                    <form action="{{ route('tailles.update', $taille) }}" method="POST" class="d-flex">
                        @csrf
                        @method('PUT')
                        <input type="text" name="taille" value="{{ $taille->taille }}" class="form-control me-2" required>
                        <button class="btn btn-success btn-sm">Modifier</button>
                    </form>
                </td>
                <td>
                    <form action="{{ route('tailles.destroy', $taille) }}" method="POST" onsubmit="return confirm('Supprimer ?')">
                        @csrf
                        @method('DELETE')
                        <button class="btn btn-danger btn-sm">Supprimer</button>
                    </form>
                </td>
            </tr>
        @endforeach
        </tbody>
    </table>
</div></div>
@endsection
