@extends('layouts.app')

@section('content')
<div class="container">
    <h2 class="mb-4">Gestion des utilisateurs et rôles</h2>

    <!-- Bouton Ajouter Utilisateur -->
    <button class="btn btn-primary mb-3" data-bs-toggle="modal" data-bs-target="#addRoleModal">
        Ajouter un Rôle
    </button>

    <table class="table table-bordered">
        <thead>
            <tr>
                <th>ID</th>
                <th>Nom</th>
                <th>Email</th>
                <th>Rôle(s)</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($users as $user)
            <tr>
                <td>{{ $user->id }}</td>
                <td>{{ $user->name }}</td>
                <td>{{ $user->email }}</td>
                <td>
                    @foreach ($user->roles as $role)
                        <span class="badge bg-success">{{ $role->name }}</span>
                    @endforeach
                </td>
                <td>
                    <!-- Modifier Rôle -->
                    <button class="btn btn-warning btn-sm editRoleBtn"
                        data-bs-toggle="modal"
                        data-bs-target="#editRoleModal"
                        data-userid="{{ $user->id }}"
                        data-username="{{ $user->name }}"
                        data-userroles="{{ $user->roles->pluck('name')->implode(', ') }}">
                        Modifier
                    </button>

                    <!-- Supprimer Rôle -->
                    <button class="btn btn-danger btn-sm deleteRoleBtn"
                        data-bs-toggle="modal"
                        data-bs-target="#deleteRoleModal"
                        data-userid="{{ $user->id }}"
                        data-username="{{ $user->name }}">
                        Supprimer
                    </button>
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>
</div>

<!-- ✅ Modal : Ajouter un rôle -->
<div class="modal fade" id="addRoleModal" tabindex="-1">
    <div class="modal-dialog">
        <form action="{{ route('users.addRole') }}" method="POST">
            @csrf
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Ajouter un rôle à un utilisateur</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <label>Utilisateur :</label>
                    <select name="user_id" class="form-control" required>
                        @foreach($users as $user)
                            <option value="{{ $user->id }}">{{ $user->name }}</option>
                        @endforeach
                    </select>

                    <label class="mt-2">Rôle :</label>
                    <select name="role" class="form-control" required>
                        @foreach($roles as $role)
                            <option value="{{ $role->name }}">{{ $role->name }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Ajouter</button>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- ✅ Modal : Modifier un rôle -->
<div class="modal fade" id="editRoleModal" tabindex="-1">
    <div class="modal-dialog">
        <form action="{{ route('users.updateRole') }}" method="POST">
            @csrf
            @method('PUT')
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Modifier le rôle</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <input type="hidden" name="user_id" id="editUserId">
                    <p>Modifier le rôle de <strong id="editUserName"></strong></p>
                    
                    <label>Rôle :</label>
                    <select name="role" class="form-control" required>
                        @foreach($roles as $role)
                            <option value="{{ $role->name }}">{{ $role->name }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-warning">Modifier</button>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- ✅ Modal : Supprimer un rôle -->
<div class="modal fade" id="deleteRoleModal" tabindex="-1">
    <div class="modal-dialog">
        <form action="{{ route('users.deleteRole') }}" method="POST">
            @csrf
            @method('DELETE')
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Supprimer un rôle</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <input type="hidden" name="user_id" id="deleteUserId">
                    <p>Voulez-vous vraiment supprimer les rôles de <strong id="deleteUserName"></strong> ?</p>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-danger">Supprimer</button>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- ✅ JavaScript pour gérer les modals -->
<script>
    document.querySelectorAll('.editRoleBtn').forEach(button => {
        button.addEventListener('click', function() {
            document.getElementById('editUserId').value = this.getAttribute('data-userid');
            document.getElementById('editUserName').innerText = this.getAttribute('data-username');
        });
    });

    document.querySelectorAll('.deleteRoleBtn').forEach(button => {
        button.addEventListener('click', function() {
            document.getElementById('deleteUserId').value = this.getAttribute('data-userid');
            document.getElementById('deleteUserName').innerText = this.getAttribute('data-username');
        });
    });
</script>
@endsection
