@extends('layouts.appadmin')
@section('content')
<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
<div class="container mt-3">

    <h3>{{ $produit->nom }} - Couleur: {{ $couleur->couleur }}</h3>

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif
    @if(session('error'))
        <div class="alert alert-danger">{{ session('error') }}</div>
    @endif

    <table class="table table-bordered">
        <thead>
            <tr>
                <th>Taille</th>
                <th>Quantité actuelle (Stock origine)</th>
                <th>Quantité à transférer</th>
                <th>Stock cible</th>
                <th>Action</th>
            </tr>
        </thead>
        <tbody>
            @foreach($variantes as $v)
            <tr>
                <td>{{ $v->taille->taille }}</td>
                <td>{{ $v->qty }} ({{ $v->lieustock->lieu ?? 'Inconnu' }})</td>
                <td>
                    <form action="{{ route('produit.transfer', $v->id) }}" method="POST" class="d-flex">
                        @csrf
                        <input type="number" name="qty" class="form-control me-2" min="1" max="{{ $v->qty }}" required>
                        <select name="lieustock_id" class="form-control me-2" required>
                            @foreach($lieux as $l)
                                @if($l->id != $v->lieustock_id)
                                    <option value="{{ $l->id }}">{{ $l->lieu }}</option>
                                @endif
                            @endforeach
                        </select>
                        <button type="submit" class="btn btn-success btn-sm">Transférer</button>
                    </form>
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>

</div>
@endsection
