@extends('layouts.appadmin')

@section('content')
<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
<div class="container mt-4">
    <h2>✏️ Modifier le Produit</h2>

    @if($errors->any())
        <div class="alert alert-danger">
            <ul class="mb-0">
                @foreach($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <form action="{{ route('admin.produit.update', $produit->id) }}" method="POST">
        @csrf

        <div class="mb-3">
            <label>Nom du produit</label>
            <input type="text" name="nom" class="form-control" value="{{ old('nom', $produit->nom) }}" required>
        </div>

        <div class="mb-3">
            <label>Catégorie</label>
            <select name="topcat_id" class="form-control" required>
                @foreach($categories as $cat)
                    <option value="{{ $cat->id }}" {{ $cat->id == $produit->topcat_id ? 'selected' : '' }}>
                        {{ $cat->topcat }}
                    </option>
                @endforeach
            </select>
        </div>

        <div class="mb-3">
            <label>Prix d'achat (DH)</label>
            <input type="number" name="prixun" class="form-control" step="0.01" value="{{ old('prixun', $produit->prixun) }}">
        </div>

        <div class="mb-3">
            <label>Prix de vente (DH)</label>
            <input type="number" name="prixvents" class="form-control" step="0.01" value="{{ old('prixvents', $produit->prixvents) }}">
        </div>

        <button type="submit" class="btn btn-success">💾 Enregistrer</button>
        <a href="{{ route('admin.produits.index') }}" class="btn btn-secondary">↩️ Retour</a>
    </form>
</div>
@endsection
