@extends('layouts.appadmin')

@section('content')
<div class="content-wrapper">
  <div class="container mt-3">
    <div class="card">
      <div class="card-header bg-info text-white">Ajouter Produit</div>
      <div class="card-body">

        <!-- Formulaire -->
        <form action="{{ asset('addproduit2') }}" method="POST" enctype="multipart/form-data">
          @csrf

          <!-- Lieu de Stock -->
          <div class="mb-3">
            <label>Lieu de Stock :</label>
            <select name="lieu" class="form-control" required>
              <option value="">-- Choisir lieu --</option>
              @foreach($lieux as $lieu)
                <option value="{{ $lieu->id }}">{{ $lieu->lieu }}</option>
              @endforeach
            </select>
          </div>

          <!-- Catégorie -->
          <div class="mb-3">
            <label>Catégorie :</label>
            <select name="topcat" class="form-control" required>
              <option value="">-- Choisir catégorie --</option>
              @foreach($categories as $cat)
                <option value="{{ $cat->id }}">{{ $cat->topcat }}</option>
              @endforeach
            </select>
          </div>

          <!-- Nom / Désignation -->
          <div class="mb-3">
            <label>Nom / Désignation :</label>
            <input type="text" name="nom" class="form-control" placeholder="Nom du produit" required>
          </div>

          <!-- Couleur -->
          <div class="mb-3">
            <label>Couleur :</label>
            <select name="couleur_id" class="form-control" required>
              <option value="">-- Choisir couleur --</option>
              @foreach($couleurs as $c)
                <option value="{{ $c->id }}">{{ $c->couleur }}</option>
              @endforeach
            </select>
          </div>

          <!-- Taille -->
          <div class="mb-3">
            <label>Taille :</label>
            <select name="taille_id" class="form-control" required>
              <option value="">-- Choisir taille --</option>
              @foreach($tailles as $t)
                <option value="{{ $t->id }}">{{ $t->taille }}</option>
              @endforeach
            </select>
          </div>

          <!-- Prix et Quantité -->
          <div class="row">
            <div class="col-md-4 mb-3">
              <label>Prix Unitaire :</label>
              <input type="number" name="prixun" class="form-control" step="0.01" required>
            </div>
            <div class="col-md-4 mb-3">
              <label>Prix Vente :</label>
              <input type="number" name="prixvents" class="form-control" step="0.01" required>
            </div>
            <div class="col-md-4 mb-3">
              <label>Quantité :</label>
              <input type="number" name="qty" class="form-control" required>
            </div>
          </div>

          <!-- Image -->
          <div class="mb-3">
            <label>Image :</label>
            <input type="file" name="image" class="form-control" accept="image/*">
          </div>

          <!-- Bouton Ajouter -->
          <button type="submit" class="btn btn-success w-100">Ajouter Produit</button>

        </form>

      </div>
    </div>
  </div>
</div>
@endsection
