@extends('layouts.appadmin')

@section('content')

<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
<div class="container mt-4">
    <h2 class="mb-4">📦 Liste des Produits</h2>

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif
<form method="GET" action="{{ route('admin.produits.index') }}" class="mb-4 d-flex" role="search">
    <input type="text" name="search" class="form-control me-2" placeholder="🔍 Rechercher par nom..." value="{{ request('search') }}">
    <button type="submit" class="btn btn-primary">Rechercher</button>
</form>

    <table class="table table-bordered table-striped">
        <thead class="table-dark">
            <tr>
                <th>#</th>
                <th>Image</th>
                <th>Nom</th>
                <th>Catégorie</th>
                <th>Prix Achat</th>
                <th>Prix Vente</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            @foreach($produits as $produit)
            <tr>
                <td>{{ $loop->iteration }}</td>
                <td>
                    @if($produit->img)
                        <img src="{{ asset('storage/' . $produit->img) }}" alt="img" width="50">
                    @else
                        <span class="text-muted">Aucune</span>
                    @endif
                </td>
                <td>{{ $produit->nom }}</td>
                <td>{{ $produit->topcat->topcat ?? '—' }}</td>
                <td>{{ number_format($produit->prixun, 2) }} DH</td>
                <td>{{ number_format($produit->prixvents, 2) }} DH</td>
                <td>
                    <!-- Bouton Voir Détails -->
                    <a href="{{ route('admin.produit.couleur', ['produit_id' => $produit->id, 'lieustock_id' => 1]) }}" class="btn btn-sm btn-info">🔍 Détails</a>

                    <!-- Modifier -->
                    <a href="{{ route('admin.produit.edit', $produit->id) }}" class="btn btn-sm btn-warning">✏️ Modifier</a>

                    <!-- Supprimer -->
                    <form action="{{ route('admin.produit.delete', $produit->id) }}" method="POST" class="d-inline" onsubmit="return confirm('Supprimer ce produit ?')">
                        @csrf
                        @method('DELETE')
                        <button class="btn btn-sm btn-danger">🗑️ Supprimer</button>
                    </form>
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>
</div>
@endsection
