@extends('layouts.appadmin')

@section('content')
<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
<div class="container mt-4">
    <h2>Ajouter un produit</h2>

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    <form action="{{ route('admin.produit.store') }}" method="POST" enctype="multipart/form-data">
        @csrf
        <div class="form-group">
            <label>Nom du produit</label>
            <input type="text" name="nom" class="form-control" required>
        </div>

        <div class="form-group">
            <label>Catégorie principale</label>
            <select name="topcat_id" class="form-control" required>
                @foreach(App\Models\Topcat::all() as $cat)
                    <option value="{{ $cat->id }}">{{ $cat->topcat }}</option>
                @endforeach
            </select>
        </div>

        <div class="form-group">
            <label>Prix unitaire</label>
            <input type="number" name="prixun" class="form-control">
        </div>

        <div class="form-group">
            <label>Prix de vente</label>
            <input type="number" name="prixvents" class="form-control">
        </div>

        <div class="form-group">
            <label>Image</label>
            <input type="file" name="img" class="form-control">
        </div>

        <button type="submit" class="btn btn-primary mt-2">Ajouter</button>
    </form>
</div>
</div></div>
@endsection
