<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <style>
        body { font-family: DejaVu Sans, sans-serif; font-size: 12px; }
        table { width: 100%; border-collapse: collapse; margin-top: 10px; }
        th, td { border: 1px solid #333; padding: 6px; text-align: center; }
        th { background-color: #f0f0f0; }
        .header { margin-bottom: 20px; }
        .header p { margin: 2px 0; }
        h2 { margin-bottom: 5px; }
    </style>
</head>
<body>
    <!-- Header -->
    <div class="header">
        <h2 style="text-align:center;">📊 Stock disponible</h2>
        <p><strong>Entreprise:</strong> {{ $info->nom ?? '-' }}</p>

        @if(request('lieustock_id'))
            <p><strong>Stock:</strong> {{ \App\Models\lieustock::find(request('lieustock_id'))->lieu ?? '-' }}</p>
        @else
            <p><strong>Stock:</strong> Tous</p>
        @endif

        @if(request('categorie_id'))
            <p><strong>Catégorie:</strong> {{ \App\Models\topcat::find(request('categorie_id'))->topcat ?? '-' }}</p>
        @else
            <p><strong>Catégorie:</strong> Toutes</p>
        @endif

        <p><strong>Date:</strong> {{ date('d/m/Y') }}</p>
        <p><strong>Total Produits:</strong> {{ $produits->count() }}</p>
    </div>

    <!-- Table des produits -->
    <table>
        <thead>
            <tr>
                <th>Produit</th>
                <th>Catégorie</th>
                <th>Couleur</th>
                <th>Taille</th>
                <th>Stock</th>
                <th>Quantité</th>
            </tr>
        </thead>
        <tbody>
            @forelse($produits as $pv)
                <tr>
                    <td>{{ $pv->produit->nom ?? '-' }}</td>
                    <td>{{ $pv->produit->topcat->topcat ?? '-' }}</td>
                    <td>{{ $pv->couleur->couleur ?? '-' }}</td>
                    <td>{{ $pv->taille->taille ?? '-' }}</td>
                    <td>{{ $pv->lieustock->lieu ?? '-' }}</td>
                    <td>{{ $pv->qty ?? 0 }}</td>
                </tr>
            @empty
                <tr>
                    <td colspan="6" class="text-center">Aucun produit trouvé</td>
                </tr>
            @endforelse
        </tbody>
    </table>
</body>
</html>
