@extends('layouts.appadmin')

@section('content')
  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
      <div class="container-fluid">
    <h2>Historique des transferts</h2>

    {{-- Formulaire filtre --}}
 <form action="{{ route('mouvements.index') }}" method="GET" style="margin-bottom:20px;">
    <label>Filtrer par jour :</label>
    <input type="date" name="date" value="{{ request('date') }}">

    <label>Ou entre :</label>
    <input type="date" name="start_date" value="{{ request('start_date') }}">
    <input type="date" name="end_date" value="{{ request('end_date') }}">

    <button type="submit">Rechercher</button>
    <button type="submit" name="pdf" value="1">Télécharger PDF</button>
</form>

@if($periode)
<p><strong>Période affichée :</strong> {{ $periode }}</p>
@endif


    <table border="1" cellpadding="8" cellspacing="0" style="width:100%;">
        <thead>
            <tr>
                <th>Date</th>
                <th>Produit</th>
                <th>Couleur</th>
                <th>Taille</th>
                <th>Quantité</th>
                <th>Stock Origine</th>
                <th>Stock Destination</th>
            </tr>
        </thead>
        <tbody>
            @forelse($mouvements as $m)
            <tr>
                <td>{{ $m->created_at->format('d/m/Y H:i') }}</td>
                <td>{{ $m->produit->nom ?? 'Inconnu' }}</td>
                <td>{{ $m->couleur_id ?? '-' }}</td>
                <td>{{ $m->taille_id ?? '-' }}</td>
                <td>{{ $m->qty }}</td>
                <td>{{ $m->stockOrigine->lieu ?? 'Inconnu' }}</td>
                <td>{{ $m->stockDestination->lieu ?? 'Inconnu' }}</td>
            </tr>
            @empty
            <tr>
                <td colspan="7" style="text-align:center;">Aucun transfert trouvé</td>
            </tr>
            @endforelse
        </tbody>
    </table>
</div>
@endsection
