@extends('layouts.appadmin')

@section('content')
  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-12">
          
            <h3 class="font-weight-bold">Gestion des Couleurs</h3>

 

    {{-- Messages --}}
    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    {{-- Ajouter Couleur --}}
    <form action="{{ route('couleurs.store') }}" method="POST" class="d-flex mb-4">
        @csrf
        <input type="text" name="couleur" class="form-control me-2" placeholder="Nouvelle couleur" required>
        <button class="btn btn-primary">Ajouter</button>
    </form>

    {{-- Liste des couleurs --}}
    <table class="table table-bordered">
        <thead>
            <tr>
                <th>ID</th>
                <th>Couleur</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
        @foreach($couleurs as $couleur)
            <tr>
                <td>{{ $couleur->id }}</td>
                <td>
                    <form action="{{ route('couleurs.update', $couleur) }}" method="POST" class="d-flex">
                        @csrf
                        @method('PUT')
                        <input type="text" name="couleur" value="{{ $couleur->couleur }}" class="form-control me-2" required>
                        <button class="btn btn-success btn-sm">Modifier</button>
                    </form>
                </td>
                <td>
                    <form action="{{ route('couleurs.destroy', $couleur) }}" method="POST" onsubmit="return confirm('Supprimer ?')">
                        @csrf
                        @method('DELETE')
                        <button class="btn btn-danger btn-sm">Supprimer</button>
                    </form>
                </td>
            </tr>
        @endforeach
        </tbody>
    </table>

</div></div>
</div></div>
@endsection
