@extends('layouts.appadmin')

@section('content')
  <div class="content-wrapper">
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-12">
          <button class="btn btn-primary btn-sm" data-toggle="modal" data-target="#modal-edit">
                                  Ajouter produit<i class="fas fa-edit"></i>
                                </button>
            <h3 class="font-weight-bold">Liste Produits</h3>
            <div class="modal fade" id="modal-edit" tabindex="-1" role="dialog" aria-labelledby="modalLabel" aria-hidden="true">
                                  <div class="modal-dialog modal-lg">
                                    <div class="modal-content">
                                      <div class="modal-header">
                                        <h5 class="modal-title" id="modalLabel">ajouter produit</h5>
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                          <span aria-hidden="true">&times;</span>
                                        </button>
                                      </div>
                                      <div class="modal-body">
                                        <form method="POST" action="{{asset('addproduit2')}}" enctype="multipart/form-data">      
                                          @csrf
                                          <div class="row">
                                            <!-- Désignation -->
                                            <div class="col-md-6">
                                              <div class="form-group">
                                                <label for="designation">Désignation</label>
                                                <input name="nom"  type="text" class="form-control" placeholder="Désignation">
                                              </div>
                                            </div>

                                            <!-- Référence -->
                                            <div class="col-md-6">
                                              <div class="form-group">
                                                <label for="reference">Référence</label>
                                                <input name="ref"  type="text" class="form-control" placeholder="Référence">
                                              </div>
                                            </div>

                                            <!-- Catégorie -->
                                            <div class="col-md-6">
                                              <div class="form-group">
                                                <label for="categorie">Catégorie</label>
                                                <select name="cat" class="form-control" id="exampleFormControlSelect1">
                                                  @foreach($categories as $cat)
                                                  <option value="{{$cat->id}}">{{$cat->topcat}}</option>
     
                                                     @endforeach
                                                         </select>
                                              </div>
                                            </div>

                                      

                                            <!-- Prix Achat -->
                                            <div class="col-md-6">
                                              <div class="form-group">
                                                <label for="prixAchat">Prix Achat</label>
                                                <input name="prixun" type="text" class="form-control" placeholder="Prix Achat">
                                              </div>
                                            </div>

                                            <!-- Prix Vente -->
                                            <div class="col-md-6">
                                              <div class="form-group">
                                                <label for="prixvents">Prix de Vente</label>
                                                <input name="prixvents"  type="text" class="form-control" placeholder="Prix de Vente">
                                              </div>
                                            </div>

                                            <!-- Quantité -->
                                            <div class="col-md-6">
                                              <div class="form-group">
                                                <label for="quantite">Quantité</label>
                                                <input name="qty" type="text" class="form-control" placeholder="Quantité">
                                              </div>
                                            </div>

                                            <!-- Image -->
                                            <div class="col-md-6">
                                              <div class="form-group">
                                                <label for="image">Image</label>
                                                <input type="file" name="image" class="form-control">
                                              </div>
                                            </div>
                                          </div>
                                          <div class="modal-footer">
                                            <button type="submit" class="btn btn-success">Enregistrer</button>
                                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Fermer</button>
                                          </div>
                                        </form>
                                      </div>
                                    </div>
                                  </div>
                                </div>

            <section class="content">
              <div class="row">
                <div class="col-12">
                  <div class="card">
                    <div class="card-header bg-info">
                      <h4 class="text-white font-weight-bold"><i class="fas fa-users"></i> Liste Produits4</h4>
                    </div>

                    <div class="card-body">
                      <div class="table-responsive">
                        <table id="example" class="table table-bordered display nowrap" cellspacing="0" width="100%">
                          <thead>
                            <tr>
                              <th>Image</th>
                              <th>ID</th>
                              <th>Désignation</th>
                              <th>Prix Achat</th>
                              <th>Prix de Vente</th> 
                              <th>Quantité</th>
                              <th>Reference</th>
                              <th>Lieu de Stock</th>
                              <th>Catégorie</th>
                              <th>Action</th>
                            </tr>
                          </thead>
                          <tbody>
                            @foreach($produits as $produit)
                            <tr>
                              <td><img src="{{'img/'.$produit->img}}" alt="Image" style="width: 50px; height: 50px;"></td>
                              <td>{{$produit->id}}</td>
                              <td><a class="text-primary font-weight-bold" href="{{asset('detaille/'.$produit->id)}}">{{$produit->nom}}</a></td>
                              <td class=" font-weight-bold">{{$produit->prixun}}</td>
                              <td class="text-success font-weight-bold">{{$produit->prixvents}}</td>
                              <td>{{$produit->stock}}</td>
                              <td class="text-primary font-weight-bold">{{$produit->ref}}</td>
                              <td class="text-warning font-weight-bold">{{$produit->lieustock->lieu}}</td>
                              <td>{{$produit->topcat->topcat}}</td>
                              <td>
                                <!-- Bouton Supprimer -->
                                <a href="{{asset('deleteproduit/'.$produit->id)}}"  class="btn btn-danger btn-sm">
                                  <i class="fas fa-trash"></i>
                                </a>

                                <!-- Bouton Éditer -->
                                <button class="btn btn-primary btn-sm" data-toggle="modal" data-target="#modal-edit-{{$produit->id}}">
                                  <i class="fas fa-edit"></i>
                                </button>

                                <!-- Modal d'édition -->
                                <div class="modal fade" id="modal-edit-{{$produit->id}}" tabindex="-1" role="dialog" aria-labelledby="modalLabel" aria-hidden="true">
                                  <div class="modal-dialog modal-lg">
                                    <div class="modal-content">
                                      <div class="modal-header">
                                        <h5 class="modal-title" id="modalLabel">Modifier le produit</h5>
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                          <span aria-hidden="true">&times;</span>
                                        </button>
                                      </div>
                                      <div class="modal-body">
                                        <form method="POST" action="{{asset('updatproduit/'.$produit->id)}}" enctype="multipart/form-data">      
                                          @csrf
                                          <div class="row">
                                            <!-- Désignation -->
                                            <div class="col-md-6">
                                              <div class="form-group">
                                                <label for="designation">Désignation</label>
                                                <input name="nom" value="{{$produit->nom}}" type="text" class="form-control" placeholder="Désignation">
                                              </div>
                                            </div>

                                            <!-- Référence -->
                                            <div class="col-md-6">
                                              <div class="form-group">
                                                <label for="reference">Référence</label>
                                                <input name="ref" value="{{$produit->ref}}" type="text" class="form-control" placeholder="Référence">
                                              </div>
                                            </div>

                                            <!-- Catégorie -->
                                            <div class="col-md-6">
                                              <div class="form-group">
                                                <label for="categorie">Catégorie</label>
                                                <select name="cat" class="form-control">
                                                  @foreach($categories as $cat)
                                                    <option value="{{$cat->id}}" {{$cat->id == $produit->topcat_id ? 'selected' : ''}}>{{$cat->topcat}}</option>
                                                  @endforeach
                                                </select>
                                              </div>
                                            </div>

                                            <!-- Fournisseur -->
                                            <div class="col-md-6">
                                              <div class="form-group">
                                                <label for="fournisseur">Fournisseur</label>
                                                <select name="fournisseur_id" class="form-control">
                                                  @foreach($fournisseurs as $fourn)
                                                    <option value="{{$fourn->id}}" {{$fourn->id == $produit->fournisseur_id ? 'selected' : ''}}>{{$fourn->nom}}</option>
                                                  @endforeach
                                                </select>
                                              </div>
                                            </div>

                                            <!-- Prix Achat -->
                                            <div class="col-md-6">
                                              <div class="form-group">
                                                <label for="prixAchat">Prix Achat</label>
                                                <input name="prixun" value="{{$produit->prixun}}" type="text" class="form-control" placeholder="Prix Achat">
                                              </div>
                                            </div>

                                            <!-- Prix Vente -->
                                            <div class="col-md-6">
                                              <div class="form-group">
                                                <label for="prixVente">Prix de Vente</label>
                                                <input name="prixvente" value="{{$produit->prixvents}}" type="text" class="form-control" placeholder="Prix de Vente">
                                              </div>
                                            </div>

                                            <!-- Quantité -->
                                            <div class="col-md-6">
                                              <div class="form-group">
                                                <label for="quantite">Quantité</label>
                                                <input name="qty" value="{{$produit->stock}}" type="text" class="form-control" placeholder="Quantité">
                                              </div>
                                            </div>

                                            <!-- Image -->
                                            <div class="col-md-6">
                                              <div class="form-group">
                                                <label for="image">Image</label>
                                                <input type="file" name="image" class="form-control">
                                              </div>
                                            </div>
                                          </div>
                                          <div class="modal-footer">
                                            <button type="submit" class="btn btn-success">Enregistrer</button>
                                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Fermer</button>
                                          </div>
                                        </form>
                                      </div>
                                    </div>
                                  </div>
                                </div>
                              </td>
                            </tr>
                            @endforeach
                          </tbody>
                        </table>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </section>
          </div>
        </div>
      </div>
    </div>
  </div>
@endsection

<script src="{{asset('dash/plugins/jquery/jquery.min.js')}}"></script>

<script>
  $(document).ready(function () {
    $('#example').DataTable({
      responsive: true,
    });
  });
</script>
