@extends('layouts.appadmin')

@section('content')
<div class="content-wrapper">
    <div class="container mt-3">

        <h3 class="font-weight-bold">Liste Articles du stock :</h3>

        <div class="card">
            <div class="card-header bg-info text-white">Produits</div>
            <div class="card-body table-responsive">
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>Nom produit</th>
                            <th>Ref</th>
                            <th>Image</th>
                            <th>Prix Achat</th>
                            <th>Prix Vente</th>
                            <th>Quantité</th>
                            <th>Couleurs / Tailles</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($produits as $produit)
                        <tr>
                            <td>{{ $produit->produit->nom ?? '-' }}</td>
                            <td>{{ $produit->ref }}</td>
                            <td>
                                @if($produit->img)
                                    <img src="{{ asset('img/'.$produit->img) }}" width="50">
                                @endif
                            </td>
                            <td>{{ $produit->prixun }}</td>
                            <td>{{ $produit->prixvents }}</td>
                            <td>{{ $produit->qty }}</td>
                            <td>
                                @foreach($produit->produit->produit_variable as $variable)
                                    <span class="badge badge-info">{{ $variable->couleur->couleur ?? '-' }} / {{ $variable->taille->taille ?? '-' }} ({{ $variable->qty }})</span>
                                @endforeach
                            </td>
                            <td>
                                <a href="{{ url('entrer/'.$produit->id) }}" class="btn btn-success btn-sm"><i class="fas fa-plus"></i></a>
                                <a href="{{ url('sortie/'.$produit->id) }}" class="btn btn-warning btn-sm"><i class="fas fa-minus"></i></a>

                                <!-- Bouton Ajouter Couleur/Taille -->
                                <button type="button" class="btn btn-info btn-sm" data-toggle="modal" data-target="#addCouleurTailleModal{{ $produit->id }}">
                                    + Couleur/Taille
                                </button>

                                <!-- Modal Ajouter Couleur/Taille -->
                                <div class="modal fade" id="addCouleurTailleModal{{ $produit->id }}" tabindex="-1" role="dialog" aria-labelledby="addCouleurTailleModalLabel{{ $produit->id }}" aria-hidden="true">
                                    <div class="modal-dialog" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header bg-info text-white">
                                                <h5 class="modal-title" id="addCouleurTailleModalLabel{{ $produit->id }}">
                                                    Ajouter couleur et taille à {{ $produit->produit->nom }}
                                                </h5>
                                                <button type="button" class="close" data-dismiss="modal">&times;</button>
                                            </div>
                                            <div class="modal-body">
                                                <form action="{{ route('produit.storeCouleurTaille', $produit->produit->id) }}" method="POST">
                                                    @csrf
                                                    <div class="form-group">
                                                        <label>Couleur :</label>
                                                        <select name="couleur_id" class="form-control" required>
                                                            <option value="">-- Sélectionner couleur --</option>
                                                            @foreach(App\Models\couleur::all() as $c)
                                                                <option value="{{ $c->id }}">{{ $c->couleur }}</option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                    <div class="form-group">
                                                        <label>Taille :</label>
                                                        <select name="taille_id" class="form-control" required>
                                                            <option value="">-- Sélectionner taille --</option>
                                                            @foreach(App\Models\taille::all() as $t)
                                                                <option value="{{ $t->id }}">{{ $t->taille }}</option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                    <div class="form-group">
                                                        <label>Quantité :</label>
                                                        <input type="number" name="qty" class="form-control" value="0" min="0" required>
                                                    </div>
                                                    <input type="hidden" name="lieustock_id" value="{{ $produit->lieustock_id }}">
                                                    <button type="submit" class="btn btn-success w-100">Ajouter</button>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <button class="btn btn-primary btn-sm" data-toggle="modal" data-target="#editModal{{$produit->id}}">
                                    <i class="fas fa-edit"></i>
                                </button>
                                <button class="btn btn-success btn-sm" data-toggle="modal" data-target="#detailModal{{$produit->id}}">
                                    <i class="fas fa-info-circle"></i>
                                </button>
                                <a href="{{ url('deleteproduit/'.$produit->id) }}" class="btn btn-danger btn-sm"><i class="fas fa-trash"></i></a>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>

                <div class="d-flex justify-content-center mt-3">
                    {{ $produits->links('pagination::bootstrap-4') }}
                </div>
            </div>
        </div>

    </div>
</div>
@endsection

<!-- Scripts nécessaires pour Bootstrap modal -->
<script src="{{ asset('dash/plugins/jquery/jquery.min.js') }}"></script>
<script src="{{ asset('dash/plugins/bootstrap/js/bootstrap.bundle.min.js') }}"></script>
