@extends('layouts.appadmin')
@section('content')
<h3>Tailles pour la couleur : {{ $couleur->couleur }}</h3>

<form action="{{ route('produit.taille.add', $couleur->id) }}" method="POST">
    @csrf
    <select name="taille_id" required>
        @foreach($taillesDisponibles as $taille)
            <option value="{{ $taille->id }}">{{ $taille->taille }}</option>
        @endforeach
    </select>
    <button type="submit" class="btn btn-success">Ajouter Taille</button>
</form>

<table class="table table-bordered mt-3">
    <thead>
        <tr>
            <th>Produit</th>
            <th>Taille</th>
        </tr>
    </thead>
    <tbody>
        @foreach($produitVariables as $pv)
            <tr>
                <td>{{ $pv->produit->nom }}</td>
                <td>{{ $pv->taille->taille ?? '-' }}</td>
            </tr>
        @endforeach
    </tbody>
</table>
@endsection
