@extends('layouts.appadmin')
@section('content')
<h3>Couleurs du produit : {{ $produit->nom }}</h3>

<form action="{{ route('produit.couleur.add', $produit->id) }}" method="POST">
    @csrf
    <select name="couleur_id" required>
        @foreach($couleursDisponibles as $couleur)
            <option value="{{ $couleur->id }}">{{ $couleur->couleur }}</option>
        @endforeach
    </select>
    <button type="submit" class="btn btn-success">Ajouter Couleur</button>
</form>

<table class="table table-bordered mt-3">
    <thead>
        <tr>
            <th>Couleur</th>
            <th>Actions</th>
        </tr>
    </thead>
    <tbody>
        @foreach($couleurs as $couleur)
            <tr>
                <td>{{ $couleur->couleur }}</td>
                <td>
                    <a href="{{ route('produit.taille', $couleur->id) }}" class="btn btn-info btn-sm">Voir Tailles</a>
                </td>
            </tr>
        @endforeach
    </tbody>
</table>
@endsection
