@extends('layouts.appadmin')
@section('content')
<div class="content-wrapper">
    <div class="content-header">
        <div class="container-fluid">
<div class="container">
    <h3 class="mb-3">📦 Filtrer Produits par Lieu & Catégorie</h3>

    <!-- Formulaire avec listes déroulantes -->
    <form method="GET" action="{{ route('admin.produit.filter') }}">
        <div class="row mb-4">
            <div class="col-md-4">
                <label for="lieustock_id">Lieu de Stock</label>
                <select name="lieustock_id" id="lieustock_id" class="form-control">
                    <option value="">-- Tous --</option>
                    @foreach($lieux as $ls)
                        <option value="{{ $ls->id }}" {{ request('lieustock_id') == $ls->id ? 'selected' : '' }}>
                            {{ $ls->lieu }}
                        </option>
                    @endforeach
                </select>
            </div>

            <div class="col-md-4">
                <label for="categorie_id">Catégorie</label>
                <select name="categorie_id" id="categorie_id" class="form-control">
                    <option value="">-- Toutes --</option>
                    @foreach($categories as $cat)
                        <option value="{{ $cat->id }}" {{ request('categorie_id') == $cat->id ? 'selected' : '' }}>
                            {{ $cat->topcat }}
                        </option>
                    @endforeach
                </select>
            </div>

            <div class="col-md-4 d-flex align-items-end">
                <button type="submit" class="btn btn-primary w-100">🔍 Rechercher</button>
            </div>
        </div>
    </form>
<a href="{{ route('admin.produit.pdf', request()->all()) }}" class="btn btn-danger mb-3" target="_blank">
    📥 Télécharger en PDF
</a>

    <!-- Table des produits -->
    <table class="table table-bordered table-striped">
        <thead class="table-dark">
            <tr>
                <th>Produit</th>
                <th>Catégorie</th>
                <th>Couleur</th>
                <th>Taille</th>
                <th>Stock</th>
                <th>Quantité</th>
            </tr>
        </thead>
        <tbody>
            @forelse($produits as $pv)
                <tr>
                    <td>{{ $pv->produit->nom }}</td>
                    <td>{{ $pv->produit->topcat->topcat ?? '-' }}</td>
                    <td>{{ $pv->couleur->couleur ?? '-' }}</td>
                    <td>{{ $pv->taille->taille ?? '-' }}</td>
                    <td>{{ $pv->lieustock->lieu ?? '-' }}</td>
                    <td>{{ $pv->qty ?? 0 }}</td>
                </tr>
            @empty
                <tr>
                    <td colspan="6" class="text-center text-muted">Aucun produit trouvé</td>
                </tr>
            @endforelse
        </tbody>
    </table>
</div>
@endsection
