@extends('layouts.appadmin')

@section('content')
<div class="content-wrapper">
    <div class="container mt-3">

        <h3 class="font-weight-bold">Mouvement Produit :</h3>

        @if(session('success'))
            <div class="alert alert-success">{{ session('success') }}</div>
        @endif
        @if(session('error'))
            <div class="alert alert-danger">{{ session('error') }}</div>
        @endif

        <div class="card">
            <div class="card-header bg-info text-white">
                Mouvement pour : {{ $produit->produit->nom }}
            </div>
            <div class="card-body">

                <form action="{{ url('mouvement-produit') }}" method="POST">
                    @csrf
                    <input type="hidden" name="produit_id" value="{{ $produit->id }}">

                    <div class="mb-3">
                        <label>Stock Actuel :</label>
                        <input type="text" class="form-control" value="{{ $produit->lieustock->lieu ?? '-' }}" disabled>
                    </div>

                    <div class="mb-3">
                        <label>Quantité disponible :</label>
                        <input type="number" class="form-control" value="{{ $produit->qty }}" disabled>
                    </div>

                    <div class="mb-3">
                        <label>Quantité à transférer :</label>
                        <input type="number" name="qty" class="form-control" max="{{ $produit->qty }}" required>
                    </div>

                    <div class="mb-3">
                        <label>Stock Destination :</label>
                        <select name="stock_dest" class="form-control" required>
                            <option value="">-- Choisir un stock --</option>
                            @foreach($lieux as $lieu)
                                @if($lieu->id != $produit->lieustock_id)
                                    <option value="{{ $lieu->id }}">{{ $lieu->lieu }}</option>
                                @endif
                            @endforeach
                        </select>
                    </div>

                    @if($produit->produit->produit_variable->count() > 0)
                    <div class="mb-3">
                        <label>Couleur :</label>
                        <select name="couleur_id" class="form-control">
                            <option value="">-- Choisir une couleur --</option>
                            @foreach($produit->produit->produit_variable as $var)
                                <option value="{{ $var->couleur_id }}">{{ $var->couleur->couleur ?? '-' }}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="mb-3">
                        <label>Taille :</label>
                        <select name="taille_id" class="form-control">
                            <option value="">-- Choisir une taille --</option>
                            @foreach($produit->produit->produit_variable as $var)
                                <option value="{{ $var->taille_id }}">{{ $var->taille->taille ?? '-' }}</option>
                            @endforeach
                        </select>
                    </div>
                    @endif

                    <button type="submit" class="btn btn-success w-100">Effectuer le mouvement</button>
                </form>

            </div>
        </div>

    </div>
</div>
@endsection
