@extends('layouts.appuser')
@section('content')
<div class="container">
    <div class="row">
        <!-- Ventes mensuelles -->
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Ventes Mensuelles 📊</h3>
                </div>
                <div class="card-body">
                    <canvas id="barChart"></canvas>
                </div>
            </div>
        </div>

        <!-- Produits les plus vendus -->
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Produits les plus vendus 🥧</h3>
                </div>
                <div class="card-body">
                    <canvas id="pieChart"></canvas>
                </div>
            </div>
        </div>
    </div>

    <div class="row mt-4">
        <!-- Clients qui ont le plus acheté -->
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Clients qui ont le plus acheté 👥</h3>
                </div>
                <div class="card-body">
                    <canvas id="clientChart"></canvas>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Charger Chart.js -->
<script src="{{ asset('dash/plugins/chart.js/Chart.min.js') }}"></script>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        var months = @json($months);
        var salesData = @json($salesData);
        var produitLabels = @json($produitLabels);
        var produitData = @json($produitData);
        var clientLabels = @json($clientLabels);
        var clientData = @json($clientData);

        // 🟢 Couleurs pour les Pie Charts
        var backgroundColors = [
            'rgba(255, 99, 132, 0.5)', 'rgba(54, 162, 235, 0.5)',
            'rgba(255, 206, 86, 0.5)', 'rgba(75, 192, 192, 0.5)',
            'rgba(153, 102, 255, 0.5)'
        ];
        var borderColor = backgroundColors.map(color => color.replace('0.5', '1'));

        // 🟢 1️⃣ Graphique des ventes mensuelles
        var ctxBar = document.getElementById('barChart').getContext('2d');
        new Chart(ctxBar, {
            type: 'bar',
            data: {
                labels: months,
                datasets: [{
                    label: 'Ventes (€)',
                    data: salesData,
                    backgroundColor: 'rgba(23, 162, 184, 0.5)',
                    borderColor: 'rgb(23, 162, 184)',
                    borderWidth: 1
                }]
            },
            options: {
                responsive: true,
                scales: {
                    y: { beginAtZero: true }
                }
            }
        });

        // 🟢 2️⃣ Graphique des produits les plus vendus
        var ctxPie = document.getElementById('pieChart').getContext('2d');
        new Chart(ctxPie, {
            type: 'pie',
            data: {
                labels: produitLabels,
                datasets: [{
                    label: 'Produits Vendus',
                    data: produitData,
                    backgroundColor: backgroundColors,
                    borderColor: borderColor,
                    borderWidth: 1
                }]
            },
            options: {
                responsive: true
            }
        });

        // 🟢 3️⃣ Graphique des clients qui ont le plus acheté
        var ctxClient = document.getElementById('clientChart').getContext('2d');
        new Chart(ctxClient, {
            type: 'bar',
            data: {
                labels: clientLabels,
                datasets: [{
                    label: 'Montant Total Achats (€)',
                    data: clientData,
                    backgroundColor: 'rgba(255, 159, 64, 0.5)',
                    borderColor: 'rgb(255, 159, 64)',
                    borderWidth: 1
                }]
            },
            options: {
                responsive: true,
                scales: {
                    y: { beginAtZero: true }
                }
            }
        });

    });
</script>
@endsection
