@extends('layouts.app')
<style>
    body {
        background: linear-gradient(135deg, rgba(23, 162, 184, 0.8), rgba(0, 123, 255, 0.8)), 
            url('https://www.example.com/your-background-image.jpg') no-repeat center center fixed;
        background-size: cover;
        height: 100vh;
        display: flex;
        justify-content: center;
        align-items: center;
        margin: 0;
        font-family: Arial, sans-serif;
    }
    .card {
        width: 600px;
        border-radius: 15px;
        overflow: hidden;
        box-shadow: 0 8px 16px rgba(0, 0, 0, 0.3);
        background: rgba(255, 255, 255, 0.9);
        backdrop-filter: blur(10px);
    }
    .card-header {
        background: #17a2b8;
        color: white;
        padding: 20px;
        text-align: center;
        font-size: 1.8rem;
        font-weight: bold;
    }
    .card-body {
        padding: 30px;
        text-align: center;
    }
    a {
        text-decoration: none;
        color: #17a2b8;
        font-weight: bold;
        font-size: 1.25rem;
    }
    a:hover {
        color: #117a8b;
    }
    iframe {
        margin-top: 20px;
        border-radius: 8px;
        overflow: hidden;
        border: none;
    }
</style>

@section('content')
<div class="card">
    <div class="card-header">
        Gestion stock
    </div>
    <div class="card-body">
        <form method="POST" action="{{ route('login') }}">
            @csrf
            <div class="mb-3">
                <label for="email" class="form-label">{{ __('Adresse email') }}</label>
                <input id="email" type="email" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ old('email') }}" required autofocus placeholder="Entrez votre email">
                @error('email')
                    <span class="invalid-feedback" role="alert">
                        <strong>{{ $message }}</strong>
                    </span>
                @enderror
            </div>
            <div class="mb-3">
                <label for="password" class="form-label">{{ __('Mot de passe') }}</label>
                <input id="password" type="password" class="form-control @error('password') is-invalid @enderror" name="password" required placeholder="Entrez votre mot de passe">
                @error('password')
                    <span class="invalid-feedback" role="alert">
                        <strong>{{ $message }}</strong>
                    </span>
                @enderror
            </div>
            <div class="d-flex justify-content-between align-items-center mb-3">
                <div>
                    <input type="checkbox" name="remember" id="remember" {{ old('remember') ? 'checked' : '' }}>
                    <label for="remember" class="form-check-label">{{ __('Se souvenir de moi') }}</label>
                </div>
                @if (Route::has('password.request'))
                    <a href="{{ route('password.request') }}" class="text-decoration-none">{{ __('Mot de passe oublié ?') }}</a>
                @endif
            </div>
            <div class="d-grid mb-3">
                <button type="submit" class="btn btn-primary btn-lg">{{ __('Se connecter') }}</button>
            </div>
        </form>
     
    </div>
</div>
@endsection
