@extends('layouts.appadmin')

@section('content')

<style>
    .gradient-custom {
        background: -webkit-linear-gradient(left, #3931af, #00c6ff);
    }

    .card-custom {
        border-bottom-left-radius: 10% 50%;
        border-top-left-radius: 10% 50%;
        background-color: #f8f9fa;
    }

    .input-custom {
        background-color: white;
    }

    .white-text {
        color: hsl(52, 0%, 98%);
        font-weight: 100;
        font-size: 14px;
    }

    .back-button {
        background-color: hsl(52, 0%, 98%);
        font-weight: 700;
        color: black;
        margin-top: 50px;
    }

    .card-header-custom {
        background-color: #00c6ff;
        color: white;
    }

    .card-body-custom {
        background-color: #f8f9fa;
    }
</style>

<!-- Content Wrapper -->
<div class="content-wrapper">
    <!-- Content Header -->
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h2 style="color: blue;font-weight: bold;">Information</h2>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <!-- Button trigger modal -->
                        <button type="button" class="btn btn-info btn-lg btn-block" data-toggle="modal" data-target="#modal-xl">
                            Ajouter Information
                        </button>

                        <!-- Modal -->
                        <div class="modal fade" id="modal-xl">
                            <div class="modal-dialog modal-xl">
                                <div class="modal-content">
                                    <div class="modal-body bg-info">
                                        <div class="row mt-3 mx-3" style="margin-top:25px;">
                                            <div class="col-md-3">
                                                <div style="margin-top: 50px; margin-left: 10px;" class="text-center">
                                                    <i id="animationDemo" data-mdb-animation="slide-right" data-mdb-toggle="animation" data-mdb-animation-reset="true" data-mdb-animation-start="onScroll" data-mdb-animation-on-scroll="repeat" class="fas fa-3x fa-building text-white"></i>
                                                    <h3 class="mt-3 text-white">Bien Venue</h3>
                                                    <p class="white-text">Ces informations seront affichées sur les factures.</p>
                                                </div>
                                                <div class="text-center">
                                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Quitter</button>
                                                </div>
                                            </div>
                                            <div class="col-md-9 justify-content-center">
                                                <div class="card card-custom pb-4">
                                                    <div class="card-body mt-0 mx-5">
                                                        <div class="text-center mb-3 pb-2 mt-3">
                                                            <h4 style="color: #495057;">Information</h4>
                                                        </div>

                                                        <!-- Form -->
                                                        <form method="POST" action="{{ asset('addinfo') }}" enctype="multipart/form-data">
                                                            @csrf
                                                            <div class="row mb-4">
                                                                <div class="col">
                                                                    <div class="form-group text-info">
                                                                        <label for="nom">Nom</label>
                                                                        <input type="text" name="nom" class="form-control" id="nom" placeholder="Nom" required>
                                                                    </div>
                                                                </div>
                                                                <div class="col">
                                                                    <div class="form-group text-info">
                                                                        <label for="tele">Téléphone</label>
                                                                        <input type="text" name="tele" class="form-control" id="tele" placeholder="Téléphone" required>
                                                                    </div>
                                                                </div>
                                                            </div>

                                                            <div class="row mb-4">
                                                                <div class="col">
                                                                    <div class="form-group text-info">
                                                                        <label for="adress">Adresse</label>
                                                                        <input type="text" name="adress" class="form-control" id="adress" placeholder="Adresse" required>
                                                                    </div>
                                                                </div>
                                                                <div class="col">
                                                                    <div class="form-group text-info">
                                                                        <label for="rib">RIB</label>
                                                                        <input type="text" name="rib" class="form-control" id="rib" placeholder="RIB" required>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                          
                                                            <div class="row mb-4">
                                                                <div class="col">
                                                                    <div class="form-group text-info">
                                                                        <label for="ice">ICE</label>
                                                                        <input type="text" name="ice" class="form-control" id="ice" placeholder="ICE" required>
                                                                    </div>
                                                                </div>
                                                                <div class="col">
                                                                    <div class="form-group text-info">
                                                                        <label for="ville">Ville</label>
                                                                        <input type="text" name="ville" class="form-control" id="ville" placeholder="Ville" required>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            

                                                            <div class="row mb-4">
                                                                <div class="col">
                                                                    <div class="form-group text-info">
                                                                        <label for="line1">Ligne 1</label>
                                                                        <textarea name="line1" class="form-control" id="line1" rows="3" placeholder="Ligne 1" required></textarea>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                      
                                                            <div class="row mb-4">
                                                                <div class="col">
                                                                    <div class="form-group text-info">
                                                                        <label for="ine2">Ligne 2</label>
                                                                        <textarea name="line2" class="form-control" id="ine2" rows="3" placeholder="Ligne 2" required></textarea>
                                                                    </div>
                                                                </div>
                                                            </div>

                                                            <div class="row mb-4">
                                                                <div class="col">
                                                                    <div class="form-group text-info">
                                                                        <label for="line3">Ligne 3</label>
                                                                        <textarea name="line3" class="form-control" id="line3" rows="3" placeholder="Ligne 3" required></textarea>
                                                                    </div>
                                                                </div>
                                                            </div>

                                                            <div class="row mb-4">
                                                                <div class="col">
                                                                    <div class="form-group">
                                                                        <label for="logo">Logo</label>
                                                                        <input type="file" name="image" id="logo" class="form-control">
                                                                    </div>
                                                                </div>
                                                            </div>

                                                            <div class="float-end">
                                                                <button type="submit" class="btn btn-secondary">Enregistrer</button>
                                                            </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div> <!-- End Modal -->
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <!-- Section Content -->
    <section class="content">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header card-header-custom">
                        <div class="col-md-3 font-weight-bold">
                            <i class="fas fa fa-users"></i> Information:
                        </div>
                    </div>
                    <div class="card-body card-body-custom" style="font-size: 30px; font-weight: bold;">
                        @foreach($info as $inf)
                            <div class="col-md-12 d-flex align-items-stretch flex-column">
                                <div class="card bg-light d-flex flex-fill">
                                    <div class="card-header text-muted border-bottom-0">
                                        {{ $inf->nom }}
                                    </div>
                                    <div class="card-body pt-0">
                                        <div class="row">
                                            <div class="col-7">
                                                <h2 class="lead"><b>{{ $inf->nom }}</b></h2>
                                                <ul class="ml-4 mb-0 fa-ul text-muted">
                                                    <li class="small"><span class="fa-li"><i class="fas fa-lg fa-building"></i></span> Adresse: {{ $inf->adress }}</li>
                                                    <li class="small"><span class="fa-li"><i class="fas fa-lg fa-phone"></i></span> Téléphone: {{ $inf->tele }}</li>
                                                    <li class="small"><span class="fa-li"><i class="fas fa-lg fa-map-marker-alt"></i></span> Ville: {{ $inf->ville }}</li>
                                                    <li class="small"><span class="fa-li"><i class="fas fa-lg fa-credit-card"></i></span> RIB: {{ $inf->rib }}</li>
                                                    <li class="small"><span class="fa-li"><i class="fas fa-lg fa-university"></i></span> ICE: {{ $inf->ice }}</li>
                                                </ul>
                                            </div>
                                            <div class="col-5 text-center">
                                                <img style="width: 150px; height: 150px;" src="{{ asset('img/'.$inf->logo) }}" alt="Logo" class="img-circle img-fluid">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-footer">
                                        <div class="text-right">
                                            <a href="#" class="btn btn-sm btn-primary">
                                                <i class="fas fa-user"></i> Modifier
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

@endsection
