@extends('layouts.appadmin')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<style>
  .todo-list>li {
    font-size:16px !important;
  }
  

.todo-list>li .badge {
  font-size:20px !important;
}
</style>
@section('content')

<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
   
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0" style="color: blue;font-weight: bold;">Tableau de Bord - Gestion de Stock et Facturation</h1>
          </div><!-- /.col -->
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item active">Dashboard v1</li>
            </ol>
          </div><!-- /.col -->
        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->

    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-lg-3 col-6">
            <div class="small-box bg-info">
              <div class="inner">
                <h3 id="produitsCount">0</h3>
                <p>Produit en stock</p>
              </div>
              <div class="icon">
                <i class="ion ion-bag"></i>
              </div>
              <a href="#" class="small-box-footer">More info <i class="fas fa-arrow-circle-right"></i></a>
            </div>
          </div>
          <div class="col-lg-3 col-6">
            <div class="small-box bg-success">
              <div class="inner">
                <h3 id="alertCount">0</h3>
                <p>Repture de stock</p>
              </div>
              <div class="icon">
                <i class="ion ion-stats-bars"></i>
              </div>
              <a href="#" class="small-box-footer">More info <i class="fas fa-arrow-circle-right"></i></a>
            </div>
          </div>
          <div class="col-lg-3 col-6">
            <div class="small-box bg-warning">
              <div class="inner">
                <h3 id="ventesCount">0</h3>
                <p>Factures</p>
              </div>
              <div class="icon">
                <i class="ion ion-person-add"></i>
              </div>
              <a href="#" class="small-box-footer">More info <i class="fas fa-arrow-circle-right"></i></a>
            </div>
          </div>
          <div class="col-lg-3 col-6">
            <div class="small-box bg-danger">
              <div class="inner">
                <h3 id="capitalCount">0 DH</h3>
                <p>Capital</p>
              </div>
              <div class="icon">
                <i class="ion ion-pie-graph"></i>
              </div>
              <a href="#" class="small-box-footer">More info <i class="fas fa-arrow-circle-right"></i></a>
            </div>
          </div>
        </div>
      </div>
    </section>
        <!-- /.row -->
        <!-- Main row -->
        <div class="row">
          <!-- Left col -->
          <section class="col-lg-6 connectedSortable">
            <div class="card">
              <div class="card-header">
                 <h1 class="card-title">    <i class="ion ion-clipboard mr-1"></i> Quantités des 10 premiers produits  </h1>
                </div>
              <!-- /.card-header -->
              <div class="card-body">
                {!! $chart1->container() !!}
              </div>             
              <!-- /.card-body -->
       
            </div>
            <!-- /.card -->
          </section>        



     
          <!-- /.Left col -->
          <!-- right col (We are only adding the ID to make the widgets sortable)-->
          <section class="col-lg-6 connectedSortable">
            <!-- TO DO List -->
            <div class="card">
              <div class="card-header">
                <h1 class="card-title">
                  <i class="ion ion-clipboard mr-1"></i> Ventes Mensuelles </h1>
              
             </div>
              <!-- /.card-header -->
              <div class="card-body">
                {!! $chart2->container() !!}
              </div>
              <!-- /.card-body -->
       
            </div>
              </section>    
              <section class="col-lg-6 connectedSortable">
                <div class="card">
                  <div class="card-header">
                     <h1 class="card-title">    <i class="ion ion-clipboard mr-1"></i>Paiements</h1>
                    </div>
                  <!-- /.card-header -->
                  <div class="card-body">
                    {!! $chart3->container() !!}
                  </div>             
                  <!-- /.card-body -->
           
                </div>
                <!-- /.card -->
              </section>        
    
    
    
         
              <!-- /.Left col -->
              <!-- right col (We are only adding the ID to make the widgets sortable)-->
              <section class="col-lg-6 connectedSortable">
                <!-- TO DO List -->
                <div class="card">
                  <div class="card-header">
                    <h1 class="card-title">
                      <i class="ion ion-clipboard mr-1"></i>  Produits les plus vendus</h1>
                 </div>
                  <!-- /.card-header -->
                  <div class="card-body">
                    {!! $chart4->container() !!}
                  </div>
                  <!-- /.card-body -->
           
                </div>
                  </section>   
       
             
            <!-- /.card -->
    



       
          <!-- right col -->
        </div>
        <!-- /.row (main row) -->
      </div><!-- /.container-fluid -->
    </section>      































            <!-- /.card -->
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
  <footer class="main-footer">
    <strong>Copyright &copy; 2014-2021 <a href="https://adminlte.io">AdminLTE.io</a>.</strong>
    All rights reserved.
    <div class="float-right d-none d-sm-inline-block">
      <b>Version</b> 3.2.0
    </div>
  </footer>

  <!-- Control Sidebar -->
  <aside class="control-sidebar control-sidebar-dark">
    <!-- Control sidebar content goes here -->
  </aside>
  <!-- /.control-sidebar -->
</div>
<!-- ./wrapper -->
{!! $chart1->script() !!}
{!! $chart2->script() !!}
{!! $chart3->script() !!}
{!! $chart4->script() !!}
@endsection
<script>
  // Fonction pour animer les compteurs
  function animateCounter(id, endValue, suffix = "") {
    let count = 0;
    const speed = Math.ceil(endValue / 100); // Vitesse basée sur le nombre final
    const interval = setInterval(() => {
      count += speed;
      if (count >= endValue) {
        count = endValue;
        clearInterval(interval);
      }
      document.getElementById(id).textContent = count + suffix;
    }, 20); // Intervalle d'animation
  }

  // Données depuis votre backend
  const produits = {{ $produits->count() }};
  const alertes = {{ $alert->count() }};
  const ventes = {{ $ventes->count() }};
  const capital = {{ $totalCapital }};

  // Démarrer les animations
  animateCounter("produitsCount", produits);
  animateCounter("alertCount", alertes);
  animateCounter("ventesCount", ventes);
  animateCounter("capitalCount", capital, " DH");
</script>