@extends('layouts.appadmin')
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/datetime/1.5.1/css/dataTables.dateTime.min.css">
@section('content')
  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 style="color: blue;font-weight: bold;">Factures de vente ({{$ventes->count()}})</h1>
              
               
 



                </div><!-- /.col -->
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <a href="{{asset('vente')}}" class="btn btn-info">+facture</a>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <!-- /.content-header -->
    <form method="GET" action="{{asset('date_vente')}}" class="mb-4">
    <div class="row ml-3 ">
        <!-- Recherche par référence -->
        <div class="col-2">
        <label for="start_date">Reference</label>
            <input type="text" name="reference" class="form-control" placeholder="Référence"
                   value="{{ request()->get('reference') }}">
        </div>

        <!-- Recherche par date début -->
        <div class="col-2">
        <label for="start_date">Date de début</label>
            <input type="date" name="debut" class="form-control" placeholder="Date début"
                   value="{{ request()->get('debut') }}">
        </div>

        <!-- Recherche par date fin -->
        <div class="col-2">
        <label for="start_date">Date fin</label>
            <input type="date" name="fin" class="form-control" placeholder="Date fin"
                   value="{{ request()->get('fin') }}">
        </div>

        <!-- Filtre par statut -->
        <div class="col-2">
        <label for="start_date">Satut</label>
            <select name="statut_id" class="form-control">
                <option value="">Tous les statuts</option>
                @foreach ($encour as $statut)
                    <option value="{{ $statut->id }}" {{ request()->get('statut_id') == $statut->id ? 'selected' : '' }}>
                        {{ $statut->etat }}
                    </option>
                @endforeach
            </select>
        </div>

        <!-- Bouton de recherche -->
        <div class="col-2 d-flex align-items-end">
            <button type="submit" class="btn btn-primary w-100">
                <i class="fas fa-search"></i> Rechercher
            </button>
        </div>
    </div>
</form>

    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12 col-sm-12">
                    <div class="card card-info card-tabs">
                        <div class="card-header p-0 pt-1">
                     <h4>factures de vente</h4>
                        </div>
                        <div class="card-body">
                            <div class="tab-content" id="custom-tabs-one-tabContent">
                                <div class="tab-pane fade show active" id="custom-tabs-one-home" role="tabpanel" aria-labelledby="custom-tabs-one-home-tab">
                                <div class="card-body">
            <div class="table-responsive">
            <div class="table-responsive">
            <table id="example" class="table table-bordered display nowrap" cellspacing="0" width="100%"
                data-order='[[ 0, "desc" ]]'>
                <thead>
                <tr>
                  <th>Ref facture</th>
                  <th>client</th>
                  <th>date</th>
                  <th>Mode réglement</th>
                  <th>Total TTC</th>
                  <th>Avance</th>
                  <th>Reste</th>
                  <th style="width: 300px;">Action</th>
             
             
                </tr>
                </thead>
                <tbody>
                    @foreach($ventes as $vente)
                    <tr>
                      <td>{{$vente->id}} </td>
                    
             <td class="text-primary font-weight-bold"> {{$vente->client->nom}}  </td> 
             <td>{{date('d-m-Y', strtotime($vente->created_at))}}  </td> 
                <td> {{$vente->modepayement->mode}} </td> 
              <td class="text-primary font-weight-bold"> {{$vente->prixtotal}} DH</td>
              <td class="text-success font-weight-bold"> {{$vente->avance}} DH</td>
              <td class="text-danger font-weight-bold"> {{$vente->rest}} DH</td> 
             <td> {{$vente->encour->etat}} </td> 
             <td> 

                <a class="btn btn-info btn-sm mx-1" href="{{ url('bonlivraisonpdf/' . $vente->id) }}">

        <i class="fas fa-file-pdf"></i>
    </a>
            
    <a class="btn btn-info btn-sm mx-1" href="{{ url('ventepdf/' . $vente->id) }}">

        <i class="fas fa-file-pdf"></i>
    </a>     
  
       
        <button class="btn btn-primary btn-sm mx-1" >
            <i class="fas fa-edit"></i> 
        </button>
    
    <form style="display:inline" method="post" action="{{ asset('deletevente/'. $vente->id) }}">
        @csrf
     
        <button class="btn btn-danger btn-sm mx-1" type="submit">
            <i class="fas fa-trash"></i> 
        </button>
    </form>


         <!-- Button trigger modal -->


<!-- Modal -->
<div class="modal fade" id="exampleModal{{$vente->id}}" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
  <div class="modal-content bg-info text-white">

      <div class="modal-body">
      <div class="card-body">
            <div class="table-responsive">

                  <table id="exampl" class="table table-bordered table-striped text-center" data-order='[[ 0, "desc" ]]'>
                <thead>
                <tr>
                  <th>Ref facture</th>
                  <th>user</th>
                  <th>operation</th>
                   <th>date operation</th>
               
                
             
             
                </tr>
                </thead>
                <tbody>
 
          </tbody>
     
        </table>
 
          
          </div><!-- /.col -->
        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    
             </td> 
            
  
            </tr>
             @endforeach
          </tbody>
          <tfoot>
            <tr>
            <th></th>
                  <th></th>
                  <th></th>
                 
                  <th>Total TTC</th> 
                  <th></th>
                  <th></th>
                  <th></th>
               
             
            </tr>
        </tfoot>
        </table>     
        <div class="d-flex justify-content-center mt-4">
                                                {{ $ventes->links('pagination::bootstrap-4') }}
                                            </div>
</div>
</div></div></div>













                                </div>
                               
                </div>
            </div>
        </div>
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
@endsection

<script src="{{asset('dash/plugins/jquery/jquery.min.js')}}"></script>
<script src="https://cdn.datatables.net/datetime/1.5.1/js/dataTables.dateTime.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.2/moment.min.js"></script>
<script src="https://cdn.datatables.net/datetime/1.5.1/js/dataTables.dateTime.min.js"></script>

<script>

</script>
