<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Facture</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            background-color: #fff;
            position: relative;
        }

        .invoice-box {
            max-width: 800px;
            margin: 0 auto;
            padding: 30px;
            background-color: #fff;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.15);
            page-break-inside: avoid;
        }

        h1 {
            text-align: left;
            color: #333;
            margin-top: 0;
        }

        .invoice-date {
            text-align: right;
            margin-bottom: 20px;
            font-style: italic;
        }

        .info-container {
            display: table;
            width: 100%;
            margin-bottom: 20px;
        }

        .company-info,
        .client-info {
            display: table-cell;
            width: 50%;
            vertical-align: top;
        }

        .client-info {
            padding: 10px;
            border: 1px solid #ddd;
            border-radius: 5px;
            background-color: #f9f9f9;
        }

        .invoice-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
            page-break-inside: avoid;
        }

        .invoice-table th, .invoice-table td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }

        .invoice-table th {
            background-color: #f2f2f2;
        }

        .totals-container {
            text-align: right;
            margin-top: 20px;
        }

        .totals-container p {
            margin: 5px 0;
        }

        .total-amount {
            font-size: 1.5em;
            color: #333;
        }

        .total-in-words {
            font-style: italic;
            font-size: 0.9em;
        }

        .payment-method {
            text-align: right;
            margin-top: 10px;
        }

        .payment-method p {
            margin: 5px 0;
        }

        .separator-line {
            border: none;
            border-top: 2px solid #ddd;
            margin: 20px 0;
        }

        .footer {
            width: 100%;
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            padding: 10px;
            background-color: #fff;
            text-align: center;
            font-size: 0.9em;
            border-top: 1px solid #ddd;
            page-break-inside: avoid;
        }

        .footer p {
            margin: 5px 0;
        }

        /* Style pour le logo et le nom de la société */
        .logo-container {
            display: flex;
            align-items: center;
            margin-bottom: 20px;
        }

        .logo-container .logo img {
            max-width: 120px;  /* Réduire la taille du logo */
            height: auto;
            margin-right: 20px;
        }

        .logo-container .company-name {
            font-size: 1.5em;
            font-weight: bold;
            color: #333;
        }

        .logo-container .company-name p {
            margin: 0;
        }

        /* Reset le float */
        .clearfix::after {
            content: "";
            display: table;
            clear: both;
        }

    </style>
</head>
<body>
    <img src="data:image/png;base64,{{ base64_encode(file_get_contents(public_path('img/777.png'))) }}" alt="Logo" />
    <div class="invoice-box">
        <!-- Affichage du logo aligné à gauche et nom de la société sur la même ligne -->
     

        <div class="clearfix"></div>

        <h1>Facture N°:{{$ventes->id}}
            
        </h1>
        <p class="invoice-date">Date : {{$ventes->created_at}}</p>

        <div class="info-container">
            <div class="company-info">
                @foreach($info as $inf)
                    <p><strong> {{$inf->nom}}</strong></p>
                    <p> {{$inf->adress}}</p>
                    <p>telephone: {{$inf->tele}}</p>
                  
                @endforeach
            </div>

            <div class="client-info">
                <p><strong>Facturé à :</strong></p>
                <p>{{$ventes->client->nom}}</p>
                <p>Adresse: {{$ventes->client->adress}}</p>
                <p>Téléphone: {{$ventes->client->tele}}</p>
                <p>Email: {{$ventes->client->email}}</p>
            </div>
        </div>

        <table class="invoice-table">
            <thead>
                <tr>
                    <th>Description</th>
                    <th>Quantité</th>
                    <th>P.U</th>
                    <th>Total</th>
                </tr>
            </thead>
            <tbody>
                @foreach($ventes->detaille_vente as $det)
                    <tr>
                        <td>{{$det->nom}}</td>
                        <td>{{$det->quantite}}</td>
                        <td>{{$det->prixvents}}</td>
                        <td>{{$det->x}}</td>
                    </tr>
                @endforeach
            </tbody>
        </table>

        <div class="totals-container">
            <p>Total HT : {{$ventes->totalhtc}} DH</p>
            <p>Remise {{$ventes->remise}}% : {{$ventes->totalremise}} DH</p>
            <p>TVA {{$ventes->tva}} % : {{$ventes->totaltva}} DH</p>
            <p>Total TTC : {{$ventes->prixtotal}} DH</p>
        </div>

        <div class="payment-method">
        Mode payement :{{$ventes->modepayement->mode}}
        @if($ventes->modepayement_id==2)
        <p>Avance: {{$ventes->avance}} DH</p>
        <p>Rest : {{$ventes->rest}} DH</p>
        @endif
        </div>
    </div>

    <div class="footer">
      
        <img src="data:image/png;base64,{{ base64_encode(file_get_contents(public_path('img/6666.png'))) }}" alt="Logo" />

</div>
</body>
</html>
