<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class stock_produit extends Model
{
    use HasFactory;
    protected $table = 'stock_produits';

   protected $fillable = [
        'produit_variable_id', // lié à couleur + taille
        'lieustock_id',        // lieu du stock
        'img',                 // image du produit
        'prixun',              // prix unitaire
        'prixvents',           // prix de vente
        'qty',                 // quantité
        'ref'                  // référence optionnelle
    ];

      public function produit()
    {
        return $this->belongsTo(Produit::class, 'produit_id');
    }

    // Relation vers le produit variable (couleur/taille)
 public function produitVariable()
{
    return $this->belongsTo(produit_variable::class, 'produit_variable_id');
}
    // Relation vers le stock (lieustock)
    public function lieustock()
    {
        return $this->belongsTo(lieustock::class, 'lieustock_id');
    }
    // app/Models/stock_produit.php
    public function couleur()
    {
        return $this->belongsTo('App\Models\couleur');
    }

    public function taille()
    {
        return $this->belongsTo('App\Models\taille');
    }
}
