<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class produit extends Model
{
    use HasFactory;
      protected $table = 'produits';

    // ✅ Fillable fields
   protected $fillable = [
        'user_id',     // utilisateur qui a ajouté le produit
        'topcat_id',   // catégorie principale
        'nom',         // nom du produit
        'img',         // image du produit (nullable)
        'prixun',      // prix unitaire (nullable)
        'prixvents',   // prix de vente (nullable)
    ];

    
    public function user(){
        return $this->belongsTo('App\Models\User');
    }
    public function hystoriqprix()
    {
        return $this->hasMany('App\Models\hystoriqprix');
    }
    public function detaille_vente(){
        return $this->hasMany('App\Models\detaille_vente');
    }
    public function detaille_achat(){
        return $this->hasMany('App\Models\detaille_achat');
    }
    public function topcat(){
        return $this->belongsTo('App\Models\Topcat');
    }


    public function detaille_boncommande(){
        return $this->hasMany('App\Models\detaille_boncommande');
    }
    public function fournisseur(){
        return $this->belongsTo('App\Models\fournisseur');
    }

    public function variables()
    {
        return $this->hasMany(produit_variable::class);
    }



    
}
