<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Mouvementtransfer extends Model
{
    use HasFactory;

    protected $table = 'mouvementtransfers';

    protected $fillable = [
        'produit_id',
        'couleur_id',
        'taille_id',
        'stock_origine_id',
        'stock_destination_id',
        'qty',
    ];

    public function produit() {
        return $this->belongsTo(Produit::class);
    }

    public function couleur() {
        return $this->belongsTo(Couleur::class);
    }

    public function taille() {
        return $this->belongsTo(Taille::class);
    }

    public function stockOrigine() {
        return $this->belongsTo(Lieustock::class, 'stock_origine_id');
    }

    public function stockDestination() {
        return $this->belongsTo(Lieustock::class, 'stock_destination_id');
    }
}
