<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class User extends Authenticatable
{

 
    use HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
         'id',
        'name',
        'email',
        'password',
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    public function roles()
    {
        return $this->belongsToMany('App\Models\role', 'user_roles', 'user_id', 'role_id');
    }

    public function hasAnyRole($roles)
    {
        if (is_array($roles)) {
            foreach ($roles as $role) {
                if ($this->hasRole($role)) {
                    return true;
                }
            }
            return false; // Ajouté pour retourner false si aucun rôle n'est trouvé
        }

        return $this->hasRole($roles);
    }

    public function hasRole($role)
    {
        return $this->roles()->where('name', $role)->first() !== null;
    }
    public function vendeur()
    {
        return $this->hasMany('App\Models\Vendeur');
    }
    public function chrgement()
    {
        return $this->hasMany('App\Models\chrgement');
    }

                     public function post()
    {
        return $this->hasMany('App\Models\Post');
    }
                        public function orders()
    {
        return $this->hasMany('App\Models\order');
    }
                            public function profile()
    {
        return $this->hasOne('App\Models\profil');
    }
                               public function livreur()
    {
        return $this->hasOne('App\Models\livreur');
    }
    public function boncommande()
    {
        return $this->hasMany('App\Models\boncommande');
    }

    public function retour_chargement()
    {
        return $this->hasMany('App\Models\retour_chargement');
    }
    public function retourcommande()
    {
        return $this->hasMany('App\Models\retourcommande');
    }
    
    
}