<?php

namespace App\Http\Controllers;

use App\Models\ville;
use Illuminate\Http\Request;

class VilleController extends Controller{

    public function index()
    {
        $villes = Ville::all();
        return view('villes.index', compact('villes'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'nom' => 'required|string|max:255',
        ]);

        Ville::create(['ville' => $request->nom]);

        return redirect()->route('villes.index')->with('success', 'Ville ajoutée avec succès.');
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'nom' => 'required|string|max:255',
        ]);

        $ville = Ville::findOrFail($id);
        $ville->update(['ville' => $request->nom]);

        return redirect()->route('villes.index')->with('success', 'Ville modifiée avec succès.');
    }

    public function destroy($id)
    {
        $ville = Ville::findOrFail($id);
        $ville->delete();

        return redirect()->route('villes.index')->with('success', 'Ville supprimée avec succès.');
    }
}
