<?php

namespace App\Http\Controllers;
use App\Models\depense;
use App\Models\produit;
use App\Models\reglement_cl;
use App\Models\stock;
use App\Models\info;
use App\Models\ville;
use App\Models\statut;
use App\Models\encour;
use App\Models\vente;
use App\Models\client;
use App\Models\catclientfrn;
use App\Models\enattend;
use App\Models\caisse;
use App\Models\detaille_bonlivraison;
use App\Models\hystorique_factur;
use App\Models\bonlivraison;
use App\Models\detaille_vente;
use App\Models\hystoriqprix;
use App\Models\cheque;
use App\Models\detaille_enattend;
use Barryvdh\DomPDF\Facade\Pdf;
use Illuminate\Http\Request;
use \Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;

class VenteController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function adminpdf()
    {





        $pdf = PDF::loadView('admin.chart')->setOptions(['defaultFont' => 'sans-serif']);
        // $pdf = PDF::loadView('chart',['facture'=>$facture,'infoadmin'=>$infoadmin])->setOptions(['defaultFont' => 'sans-serif']);

        return $pdf->download('facturepdf.pdf');
    }
    public function index()
    {

        $clients = client::all();
        $villes = ville::all();
        $statuts = statut::all();
 
        return view('admin.vente', [

            'clients' => $clients,
            'villes' => $villes,
        
            'statuts' => $statuts,
        ]);
    }

    public function caissebl()
    {
        // Récupérer la date d'aujourd'hui
        $today = \Carbon\Carbon::today();
    
        // Pagination pour chaque collection (10 résultats par page par exemple)
        $caisse = caisse::whereDate('created_at', $today)->orderBy('created_at', 'desc')->paginate(10);
        $cheques = cheque::whereDate('created_at', $today)->paginate(10);
        $depenses = depense::whereDate('created_at', $today)->paginate(10);
    
        // Calcul des sommes pour aujourd'hui
        $sumcaisse = caisse::whereDate('created_at', $today)->sum('montant');
        $sumcheque = cheque::whereDate('created_at', $today)->sum('montant');
        $sumdepense = depense::whereDate('created_at', $today)->sum('depense');
    
        return view('admin.caissebl', [
            'depenses' => $depenses,
            'sumcaisse' => $sumcaisse,
            'cheques' => $cheques,
            'sumcheque' => $sumcheque,
            'sumdepense' => $sumdepense,
            'caisse' => $caisse,
        ]);
    }
    
    public function cherchcaissebl(Request $request)
    {
        // Récupérer la date d'aujourd'hui
        $today = \Carbon\Carbon::today();
    
        // Récupérer les dates de début et de fin depuis la requête, si elles existent
        $startDate = $request->input('start_date', $today->toDateString()); // Date de début (par défaut, aujourd'hui)
        $endDate = $request->input('end_date', $today->toDateString()); // Date de fin (par défaut, aujourd'hui)
    
        // Filtrer les résultats selon la période sélectionnée
        $caisse = caisse::whereBetween('created_at', [$startDate, $endDate])
                        ->orderBy('created_at', 'desc')
                        ->paginate(10);
        $cheques = cheque::whereBetween('created_at', [$startDate, $endDate])->paginate(10);
        $depenses = depense::whereBetween('created_at', [$startDate, $endDate])->paginate(10);
    
        // Calcul des sommes pour la période sélectionnée
        $sumcaisse = caisse::whereBetween('created_at', [$startDate, $endDate])->sum('montant');
        $sumcheque = cheque::whereBetween('created_at', [$startDate, $endDate])->sum('montant');
        $sumdepense = depense::whereBetween('created_at', [$startDate, $endDate])->sum('depense');
    
        return view('admin.caissebl', [
            'depenses' => $depenses,
            'sumcaisse' => $sumcaisse,
            'cheques' => $cheques,
            'sumcheque' => $sumcheque,
            'sumdepense' => $sumdepense,
            'caisse' => $caisse,
        ]);
    }
    
    public function all_ventes()
    {
       
     
        $encour = encour::orderBy('created_at','desc')->get();
        $clients = client::all();
        $villes = ville::all();
        $statuts = statut::all();
   
        $ventes = vente::orderBy('created_at','desc')->paginate(10);
        $ventes_encour = vente::where('encour_id', 2)->orderBy('created_at','desc')->get();
        $ventes_payer = vente::where('encour_id', 1)->orderBy('created_at','desc')->get();
   
       
        return view('admin.all_ventes', [

            'clients' => $clients,
            'villes' => $villes,
          
            'statuts' => $statuts,
            'ventes' => $ventes,
            'encour' => $encour,

            
            'ventes_encour' => $ventes_encour,
            'ventes_payer' => $ventes_payer,
          
          




        ]);
    }
    public function facturvente()
    {
        $encour = encour::all();
        $ventes = vente::all();
        return view('admin.facturvente', ['ventes' => $ventes, 'encour' => $encour]);
    }
    public function detaillefacturvente($id)
    {
        $info = info::all();
        $encour = encour::all();
        $ventes = vente::where('id', $id)->first();
        return view('admin.facturedetaille', ['ventes' => $ventes, 'encour' => $encour, 'info' => $info]);
    }
    public function bonlivraison()
    {
        $encour = encour::all();
        $bonlivraisons = bonlivraison::all();
        return view('admin.bonlivraison', ['bonlivraisons' => $bonlivraisons, 'encour' => $encour]);
    }
    public function reglementclient()
    {
        $clients = client::all();
        $encour = encour::all();
        $ventes = vente::where('encour_id', 2)->paginate(10);
        return view('admin.reglclient', ['ventes' => $ventes, 'encour' => $encour, 'clients' => $clients]);
    }

    public function reglementclient_all()
    {

        $encour = encour::all();
        $ventes = vente::where('encour_id', 2)->get();
        return view('admin.reglementclient_all', ['ventes' => $ventes, 'encour' => $encour]);
    }
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */

    public function blenatted()
    {

        $ventes = vente::where('bonenattentsituation_id', 1)->get();
        return view('admin.blenatted', ['ventes' => $ventes]);
    }
    public function blconfirme()
    {
        $ventes = vente::where('bonenattentsituation_id', 2)->get();
        return view('admin.blconfirme', ['ventes' => $ventes]);
    }

    public function blurgent()
    {

        $ventes = vente::where('crediiturgent_id', 2)->get();
        return view('admin.blurgent', ['ventes' => $ventes]);
    }
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
public function store(Request $request)
{
    // Validation de base
    $request->validate([
        'iduser' => 'required|integer',
        'modepayement_id' => 'required|integer',
        'totalAvecTVA' => 'required|numeric',
        'cart' => 'required|array|min:1',
        'tva' => 'nullable|numeric',
        'remise' => 'nullable|numeric',
        'remiseValue' => 'nullable|numeric',
        'tvaValue' => 'nullable|numeric',
        'totalSansTVA' => 'nullable|numeric',
        'stockdistination_id' => 'required|integer',
    ]);

    // Création d'une nouvelle vente
    $vente = new Vente();
    $vente->user_id = $request->iduser;
    $vente->prixtotal = $request->totalAvecTVA;
    $vente->stockdistination_id = $request->stockdistination_id;
    $vente->catid_distination = $request->catdistination_id;
    $vente->modepayement_id = $request->modepayement_id;
    $vente->dateecheance = Carbon::now();
    $vente->lieustock_id = 1; // stock source
    $vente->comment = "bo";
    $vente->encour_id = 1;
    $vente->tva = $request->tva;
    $vente->remise = $request->remise;
    $vente->totalremise = $request->remiseValue;
    $vente->totaltva = $request->tvaValue;
    $vente->totalhtc = $request->totalSansTVA;
    $vente->save();

    // Traitement du panier
    foreach ($request->cart as $item) {

        // Enregistrement détail de vente
        $itemVente = new detaille_vente();
        $itemVente->vente_id = $vente->id;
        $itemVente->produit_id = $item['id'];
        $itemVente->quantite = $item['quantite'];
        $itemVente->prixvents = $item['prixvente'];
        $itemVente->x = $item['total'];
        $itemVente->comme = "er";
        $itemVente->prixun = 0;
        $itemVente->nom = $item['nom'];
        $itemVente->save();

        // Produit source (stock initial)
        $produitSource = produit::where('id', $item['id'])
            ->where('lieustock_id', 1) // stock source
            ->first();

        if (!$produitSource || $produitSource->stock < $item['quantite']) {
            continue;
        }

        // Décrémenter stock source
        $produitSource->stock -= $item['quantite'];
        $produitSource->save();

        // 🔴 Mouvement sortie (source)
        $stockSortie = new stock();
        $stockSortie->user_id = $request->iduser;
        $stockSortie->produit_id = $produitSource->id;
        $stockSortie->mouvement_id = 2; // sortie
        $stockSortie->qty = $item['quantite'];
        $stockSortie->save();

        // Produit destination
        $produitDest = produit::where('ref', $produitSource->ref)
            ->where('lieustock_id', $request->stockdistination_id)
            ->first();

        if ($produitDest) {
            $produitDest->stock += $item['quantite'];
            $produitDest->save();
        } else {
            $produitDest = new produit();
            $produitDest->user_id = $request->iduser;
            $produitDest->nom = $produitSource->nom;
            $produitDest->couleur_id = $produitSource->couleur_id;
            $produitDest->taille_id = $produitSource->taille_id;
            $produitDest->ref = $produitSource->ref;
            $produitDest->minqty = $produitSource->minqty;
            $produitDest->lieustock_id = $request->stockdistination_id;
            $produitDest->topcat_id = $request->catdistination_id;
            $produitDest->prixun = 0;
            $produitDest->prixvents = $produitSource->prixvents;
            $produitDest->com = $produitSource->com;
            $produitDest->stock = $item['quantite'];
            $produitDest->img = $produitSource->img;
            $produitDest->save();
        }

        // 🟢 Mouvement entrée (destination)
        $stockEntree = new stock();
        $stockEntree->user_id = $request->iduser;
        $stockEntree->produit_id = $produitDest->id;
        $stockEntree->mouvement_id = 1; // entrée
        $stockEntree->qty = $item['quantite'];
        $stockEntree->save();
    }

    return response()->json(['id' => $vente->id]);
}


    
    public function storebonmivraison(Request $request)
    {


    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\vente  $vente
     * @return \Illuminate\Http\Response
     */
    public function moodifvente(Request $request, $id)
    {

        $vente = vente::where('id', $id)->first();
        $vente->bonenattentsituation_id = 2;
        $vente->save();
        $detaille_vente = detaille_vente::where('vente_id', $request->id)->get();
        $products_ids = $detaille_vente->pluck('produit_id')->toArray();

        $products = produit::whereIn('id', $products_ids)->get();

        foreach ($detaille_vente as $item) {
            $product = $products->where('id', $item->produit_id)->first();
            $new_stock = $product->stock - $item->qty;
            produit::where('id', $item->produit_id)->update(['stock' => $new_stock]);
        }



        /*
    $stock= new stock();
    $stock->user_id=Auth()->user()->id;
    $stock->produit_id=  $item->produit_id;
    $stock->mouvement_id=2;
    $stock->qty =$item->qty ;
    $stock->save();




  



    $caisse= new caisse();
$caisse->entrer=$request->prixtotal;
$caisse->srtie=0;
$caisse->justif="vente facture n 20";
$caisse->save();

*/




        return redirect()->back()->with('success', ' bien enregistrer');
    }

    public function modifier_vente(Request $request, $id)
    {
     
        $vente = vente::where('id', $id)->first();
        $olderest = $vente->rest;
        $esto = $request->prixtotal - $request->avance;
        $vente->user_id = Auth()->user()->id;
        $vente->prixtotal = $request->prixtotal;
        $vente->client_id = $request->client;
        $vente->modepayement_id = $request->idmod;
        $vente->dateecheance = Carbon::now();
        $vente->lieustock_id = $request->idlieutoock;
        $vente->comment = $request->comment;
        $vente->transporteur = $request->transporteur;

            //trasabilite
    $hystorique_factur= new hystorique_factur();
    $hystorique_factur->facture_id = $vente->id;
    $hystorique_factur->user_id=Auth()->user()->id;
    $hystorique_factur->catfacture_id=2; // 1 cree 2 modifier 3supprimer;
    $hystorique_factur->typecasse_id=1;// 1 vente 2 avoir 3reglement 4 achat 5 commande 6 devis;
    $hystorique_factur->save();

//hwayj moochtaraka
$caisse=caisse::where('typecasse_id', 1)
->where('entrer_id', $vente->id)
->first();
if($caisse){
$caisse->delete();}
//supprim cheque
$cheque =   cheque::where('vente_id', $vente->id)->first();
if ($cheque) {
  
    $cheque->delete();
}
$reglement = reglement_cl::where('vente_id',  $vente->id)
->get();
if($reglement){
    foreach($reglement as $reg){
      $reg->delete();  
    }
}
//fiin hwayj mochtaraka
        if ($request->bonstatut == 2) {
            switch ($request->idmod) {
                case 1://espece
           
                    //regle client  espece vercement
                    $client1 = client::where('id', $request->client)->first();
                    $client1->monton -= $vente->rest;
                    $client1->save();

                    $caisse = new caisse();
                    $caisse->typecasse_id=1;
                    $caisse->client_id = $request->client;
                    $caisse->montant = $request->prixtotal;
                    $caisse->entrer_id = $vente->id;
                    $caisse->save();
                    $vente->rest = 0; //hada dima ltht
                    $vente->avance = 0;
                    $vente->encour_id = 1; //payer
                    break;
                case 2://credit
            
                    if($vente->modepayement_id==2){
                              //regle client  espece vercement
                           $client1 = client::where('id', $request->client)->first();
                           $client1->monton -= $vente->rest;
                           $client1->save(); 
                    }
                    
        
                    $vente->rest = $request->prixtotal - $request->avance;
                    $vente->avance = $request->avance;
                    //regle client
                    $client = client::where('id', $request->client)->first();
                    $client->monton += $esto;
                    $client->save();
                    $caisse = new caisse();
                    $caisse->typecasse_id=1;
                    $caisse->client_id = $request->client;
                    $caisse->montant = $request->avance;
                    $caisse->entrer_id = $vente->id;
                    $caisse->save();
                    $vente->encour_id = 2; //credit
                    break;
                case 3://cheque
                    //supprme caisse      
     
                    //regle client  espece vercement  
                    $client1 = client::where('id', $request->client)->first();
                    $client1->monton -= $vente->rest;
                    $client1->save();
                    $vente->rest = 0; //hada dima ltht
                    $vente->avance = 0;
                    $cheque =   cheque::where('vente_id', $vente->id)->first();
                    if ($cheque) {
                        $cheque->client_id = $request->client;
                        $cheque->vente_id = $vente->id;
                        $cheque->numero = $request->numero;
                        $cheque->boonque = $request->boonque;
                        $cheque->montant = $request->prixtotal;
                        $cheque->date = $request->date;
                        $cheque->save();
                    } else {
                        $cheque1 = new cheque();
                        $cheque1->client_id = $request->client;
                        $cheque1->vente_id = $vente->id;
                        $cheque1->numero = $request->numero;
                        $cheque1->boonque = $request->boonque;
                        $cheque1->montant = $request->prixtotal;
                        $cheque1->date = $request->date;
                        $cheque1->save();
                    }
          
                    break;
                case 4://versement
                    //supprme caisse
          
                    //regle client  espece vercement
                    $client1 = client::where('id', $request->client)->first();
                    $client1->monton -= $vente->rest;
                    $client1->save();
                    $vente->rest = 0; //hada dima ltht
                    $vente->avance = 0;
                    $caisse = new caisse();
                    $caisse->typecasse_id=1;
                    $caisse->client_id = $request->client;
                    $caisse->montant = $request->prixtotal;
                    $caisse->entrer_id = $vente->id; //payer
                    $caisse->save(); //payer
                    break;
                case 5:
                    dd('5');
                    break;
            }
            $vente->save();
            //modfier cart
            if ($vente->save()) {


                foreach ($request->cart as $cart) {
                    $productIsExist = $vente->detaille_vente()->where('produit_id',$cart['id'])->first();
                    logger($productIsExist);
                    if($productIsExist){
                        $det = $productIsExist;
                        $hangeproduit = -$det->quantite + $cart['quantite'];
                        $qtyold = $det->quantite;
                        $det->vente_id = $vente->id;
                        $det->produit_id = $cart['id'];
                        $det->quantite = $cart['quantite'];
                        $det->x = $cart['x']; //twli prix vente
                        $det->comme = 'rr';
                        $det->nom = $cart['nom'];
                        $det->prixvents = $cart['prixvents'];
                        $det->prixun = 22;
                        $det->save();
                        $produit=produit::where('id',$det->produit_id)->first();
                        $produit->stock-= $hangeproduit;
                        $produit->save(); 
                            //stock
                            $stock= new stock();
                            $stock->user_id=Auth()->user()->id;
                            $stock->produit_id= $produit->id;
                            $stock->mouvement_id=2;//
                            $stock->qty = $cart['quantite'];
                            $stock->save();
                            $stock2= new stock();
                            $stock2->user_id=Auth()->user()->id;
                            $stock2->produit_id= $produit->id;
                            $stock2->mouvement_id=1;//
                            $stock2->qty = $qtyold;
                            $stock2->save();
                        
                          
                    
                    }else{
                        $vente->detaille_vente()->create([
                            'produit_id' => $cart['id'],
                            'quantite' => $cart['quantite'],
                            'x' => $cart['x'],
                            'comme' => 'ddd',
                            'nom' => $cart['nom'],
                            'prixvents' => $cart['prixvents'],
                            'prixun' => 22,
                        ]);
                        $produit = produit::where('id', $cart['id'])->first();
                        $produit->stock -= $cart['quantite'];
    
                        $produit->save();
    
                        $stock = new stock();
                        $stock->user_id = Auth()->user()->id;
                        $stock->produit_id = $produit->id;
                        $stock->mouvement_id = 2; //
                        $stock->qty = $cart['quantite'];
                        $stock->save();     
                     
                    }      
                }                
            }

            //fin modifiier cart











            //fin hna dir back();
        }




        return redirect()->back()->with('success', ' bien enregistrer');
    }












    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\vente  $vente
     * @return \Illuminate\Http\Response
     */



     public function date_vente(Request $request)
     {
         $query = vente::query();
     
         // Recherche par référence
         if ($request->filled('reference')) {
             $query->where('id', 'like', '%' . $request->reference . '%');
         }
     
         // Recherche par date
         if ($request->filled(['debut', 'fin'])) {
             $query->whereBetween('created_at', [$request->debut, $request->fin]);
         }
     
         // Recherche par statut
         if ($request->filled('statut_id')) {
             $query->where('encour_id', $request->statut_id);
         }
     
         // Pagination des résultats
         $ventes = $query->paginate(10); // 10 résultats par page
         $encour = encour::all(); // Statuts ou états possibles
     
         return view('admin.all_ventes', compact('ventes', 'encour'));
     }
     













     
    public function edit(vente $vente)
    {
        //
    }
    public function lastid()
    {
        $lasid = vente::latest('id')->first();
        return response()->json(['lasid' => $lasid]);
    }
    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\vente  $vente
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, vente $vente)
    {
        //
    }
    public function modifevente(Request $request, $id)
    {

        $ventes = vente::where('id', $id)->first();
        $detaille_vente = detaille_vente::where('vente_id', $id)->get();

        return view('admin.modifevente', ['ventes' => $ventes, 'detaille_vente' => $detaille_vente]);
    }
    public function modifevente2(Request $request)
    {

        $id = $request->idvente;
        $ventes = vente::where('id', $id)->first();
        $detaille_vente = detaille_vente::where('vente_id', $id)->get();
        return view('admin.modifevente', ['ventes' => $ventes, 'detaille_vente' => $detaille_vente]);
    }

 public function modifeventejson($id)
{
    $vente = Vente::with(['detaille_vente.produit']) // 👈 important : inclure produit
                 ->where('id', $id)->first();

    $details = $vente->detaille_vente->map(function($detail) {
        return [
            'id' => $detail->id,
            'produit_id' => $detail->produit_id,
            'nom' => $detail->produit->nom, // 👈 important !
            'quantite' => $detail->quantite,
            'prixvents' => $detail->prixvents,
            'x' => $detail->prixvents * $detail->quantite,
        ];
    });

    return response()->json([
        'ventes' => $vente,
        'detaille_vente' => $details,
    ]);
}

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\vente  $vente
     * @return \Illuminate\Http\Response
     */

    public function reglevente(Request $request)
    {
        $data = $request->ids;

        foreach ($data  as $req => $key) {

            $vente = vente::where('id', $data[$req])->first();
            //caisse

            $caisse = new caisse();
            $caisse->typecasse_id=1;
            $caisse->client_id = $vente->client_id;
            $caisse->montant = $vente->rest;
            $caisse->entrer_id = $vente->id;
            $caisse->save();

            //caisse
            $client = client::where('id', $vente->client_id)->first();

            $client->monton -= $vente->rest;

            $client->save();




            $vente->rest;
            $vente->rest = 0;
            $vente->avance = $vente->prixtotal;
           
            $vente->encour_id = 1;
            $vente->save();

            $reglement= new reglement_cl();
            $reglement->client_id=$vente->client_id;
            $reglement->vente_id=$vente->id;
            $reglement->montant=$vente->prixtotal;
            $reglement->rest=0;
            $reglement->observation="rien";
            
            $reglement->save();


            //client
        }



        return back();
    }



public function deletelignevente ($id){
   
    $detaille_vente = detaille_vente::where('id', $id)->first();
    $detaille_vente->delete();
    return response()->json(['detaille_vente' => $detaille_vente]);
}




    public function destroy($id)
    {

        $vente = vente::where('id', $id)->first();
        $client =client::where ('id', $vente->client_id)->first();
        $caisse=caisse::where('typecasse_id', 1)
        ->where('entrer_id', $vente->id)
        ->first();
        if($caisse){
        $caisse->delete();}
        if($client){
            $client->monton -= $vente->rest;
            $client->save();}
     /*
        $reglement = reglement_cl::where('vente_id',  $vente->id)
        ->get();
        if($reglement){
            foreach($reglement as $reg){
                 $reg->delete();
            }
 }*/
 $cheque = cheque::where('vente_id', $vente->id)->first();
 if($cheque){
     $cheque->delete();  
 }
   
   

        $detaille_vente = detaille_vente::where('vente_id', $vente->id)->get();
        foreach ($detaille_vente as $det) {

            $produit = produit::where('id', $det->produit_id)->first();
            $produit->stock += $det->quantite;
            $produit->save();
            $stock2 = new stock();
            $stock2->user_id = Auth()->user()->id;
            $stock2->produit_id = $produit->id;
            $stock2->mouvement_id = 1; //
            $stock2->qty = $det->quantite;
            $stock2->save();
        }
   
       foreach ($detaille_vente as $det) {
            $det->delete();
        }
        $vente->delete();




        return redirect()->back()->with('success', ' bien supprimer');
    }


    public function destcaisse($id)
    {
        $caisse=caisse::where('id', $id)->first();
        $caisse->delete();
    }

 

    public function charete()
    {
        // Récupérer les ventes groupées par mois
        $ventesParMois = Vente::selectRaw("DATE_FORMAT(created_at, '%Y-%m') as mois, SUM(prixtotal) as total_ventes")
            ->groupBy('mois')
            ->orderBy('mois', 'asc')
            ->get();

        // Préparer les données pour le graphique
        $labels = $ventesParMois->pluck('mois')->map(function ($mois) {
            return Carbon::createFromFormat('Y-m', $mois)->format('F Y'); // Ex: "January 2024"
        })->toArray();

        $data = $ventesParMois->pluck('total_ventes')->toArray();

        // Retourner la vue avec les données
        return view('admin.chart', compact('labels', 'data'));
    }}