<?php

namespace App\Http\Controllers;

use App\Models\Taille;
use Illuminate\Http\Request;

class TailleController extends Controller
{
    public function index()
    {
        $tailles = Taille::all();
        return view('tailles.index', compact('tailles'));
    }

        public function Taille()
    {
        $Taille=Taille::all();
 
        return response()->json(['Taille'=>$Taille]);
    }

    public function store(Request $request)
    {
        $request->validate([
            'taille' => 'required|string|max:255',
        ]);

        Taille::create($request->only('taille'));
        return redirect()->route('tailles.index')->with('success', 'Taille ajoutée avec succès');
    }

    public function update(Request $request, Taille $taille)
    {
        $request->validate([
            'taille' => 'required|string|max:255',
        ]);

        $taille->update($request->only('taille'));
        return redirect()->route('tailles.index')->with('success', 'Taille modifiée avec succès');
    }

    public function destroy(Taille $taille)
    {
        $taille->delete();
        return redirect()->route('tailles.index')->with('success', 'Taille supprimée avec succès');
    }
}
