<?php

namespace App\Http\Controllers;
use Abalselwi\LaravelArabicHtml\LaravelArabicHtml;
use Barryvdh\DomPDF\Facade\Pdf;
use Barryvdh\Snappy\Facades\SnappyPdf\SnappyPdf;
use I18N_Arabic as Arabic;
use mccarlosen\LaravelMpdf\Facades\LaravelMpdf;
use App\Models\vente;
use App\Models\achat;
use App\Models\info;
use App\Models\detaille_vente;
use App\Models\detaille_achat;
use App\Models\stock_produit;
use App\Models\produit_variable;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use App\Models\avoir;
use App\Models\avoir_detaille;
use App\Models\enattend;
use App\Models\detaille_enattend;
use App\Models\detaille_devis;
use App\Models\devis;
use App\Models\detaille_boncommande;
use App\Models\boncommande;
//use PDF;
class PdfController extends Controller
{
    



   

    public function ventepdf($id)
    {
        $info = info::first();
        $ventes=vente::where('id',$id)->first();
        $pdf = PDF::loadView('pdf.facturvente',['ventes'=>$ventes,'info'=>$info])->setOptions(['defaultFont' => 'sans-serif','isRemoteEnabled' => true]);
       // $pdf = PDF::loadView('chart',['facture'=>$facture,'infoadmin'=>$infoadmin])->setOptions(['defaultFont' => 'sans-serif']);

        return $pdf->download('facturepdf.pdf');
    }

    
    public function ventepdfsansentete($id){
  
       
        $vente=vente::where('id',$id)->first();
        $vente->activebutton_id=2;
        $vente->save();
              $info=info::all();
              $ventes=vente::where('id',$id)->first();
              $pdf = PDF::loadView('pdf.facturesansentet',['ventes'=>$ventes,'info'=>$info])->setOptions(['defaultFont' => 'sans-serif','isRemoteEnabled' => true]);
             // $pdf = PDF::loadView('chart',['facture'=>$facture,'infoadmin'=>$infoadmin])->setOptions(['defaultFont' => 'sans-serif']);
         
              return $pdf->download('factursansepdf.pdf');
            
          }
      

    public function bonlivraisonpdf($id){
  
       
         $info = info::first();
        $ventes=vente::where('id',$id)->first();
        $pdf = PDF::loadView('pdf.bonlivraison',['ventes'=>$ventes,'info'=>$info])->setOptions(['defaultFont' => 'sans-serif','isRemoteEnabled' => true]);
       // $pdf = PDF::loadView('chart',['facture'=>$facture,'infoadmin'=>$infoadmin])->setOptions(['defaultFont' => 'sans-serif']);

        return $pdf->download('bonlivraisonpdf.pdf');
    }

    public function devispdf($id){
  
       
  
       $info = info::first();
        $devis=devis::where('id',$id)->first();
        $pdf = PDF::loadView('pdf.devis',['devis'=>$devis,'info'=>$info])->setOptions(['defaultFont' => 'sans-serif','isRemoteEnabled' => true]);
       // $pdf = PDF::loadView('chart',['facture'=>$facture,'infoadmin'=>$infoadmin])->setOptions(['defaultFont' => 'sans-serif']);

        return $pdf->download('devispdf.pdf');
    }
    public function comandepdf($id){
  
       
  
      $info = info::first();
        $boncommandes=boncommande::where('id',$id)->first();
        $pdf = PDF::loadView('pdf.boncommandepdf',['boncommandes'=>$boncommandes,'info'=>$info])->setOptions(['defaultFont' => 'sans-serif','isRemoteEnabled' => true]);
       // $pdf = PDF::loadView('chart',['facture'=>$facture,'infoadmin'=>$infoadmin])->setOptions(['defaultFont' => 'sans-serif']);

        return $pdf->download('boncommandepdf.pdf');
    }


    public function achatpdf($id){
  
        /*   
      $vente=vente::where('id',$id)->first();
      $vente->activebutton_id=2;
      $vente->save();
      */
   //   dd($id);
            $info = info::first();
            $achats=achat::where('id',$id)->first();
            
            $pdf = PDF::loadView('pdf.facturachat',['achats'=>$achats,'info'=>$info])->setOptions(['defaultFont' => 'sans-serif','isRemoteEnabled' => true]);
           // $pdf = PDF::loadView('chart',['facture'=>$facture,'infoadmin'=>$infoadmin])->setOptions(['defaultFont' => 'sans-serif']);
       
            return $pdf->stream('achat.pdf');
         
        }


        public function avoirpdf($id){
  
      
                $info = info::first();
                $avoir=avoir::where('id',$id)->first();
                
                $pdf = PDF::loadView('pdf.avoir',['avoir'=>$avoir,'info'=>$info])->setOptions(['defaultFont' => 'sans-serif','isRemoteEnabled' => true]);
              
           
                return $pdf->stream('avoir.pdf');
             
            }
    
            public function enattendpdf($id){
  
      
                $info=info::all();
                $enattend=enattend::where('id',$id)->first();
                
                $pdf = PDF::loadView('pdf.enattend',['enattend'=>$enattend,'info'=>$info])->setOptions(['defaultFont' => 'sans-serif','isRemoteEnabled' => true]);
              
           
                return $pdf->stream('enattend.pdf');
             
            }



public function produitsPdf(Request $request)
{
    $info = info::first();

    $query = produit_variable::with(['produit.topcat','couleur','taille','lieustock']);

    if ($request->filled('lieustock_id')) {
        $query->where('lieustock_id', $request->lieustock_id);
    }

    if ($request->filled('categorie_id')) {
        $query->whereHas('produit', function($q) use ($request) {
            $q->where('topcat_id', $request->categorie_id);
        });
    }

    $produits = $query->get();

$pdf = PDF::loadView('pdf.produits', [
    'produits' => $produits,
    'info'     => $info,
])->setOptions(['defaultFont' => 'sans-serif','isRemoteEnabled' => true]);

return $pdf->stream('produits.pdf'); 
}
public function testProduitsPdf(Request $request)
{
    $info = info::first();

    $query = produit_variable::with(['produit.topcat','couleur','taille','lieustock']);

    if ($request->filled('lieustock_id')) {
        $query->where('lieustock_id', $request->lieustock_id);
    }

    if ($request->filled('categorie_id')) {
        $query->whereHas('produit', function($q) use ($request) {
            $q->where('topcat_id', $request->categorie_id);
        });
    }

    $produits = $query->get();

    // عرض البيانات مباشرة بدون PDF
    return view('pdf.produits', compact('produits','info'));
}


}
