<?php

namespace App\Http\Controllers;
use Barryvdh\DomPDF\Facade\Pdf;
use Barryvdh\Snappy\Facades\SnappyPdf\SnappyPdf;
use App\Models\mouvementtransfer;
use Illuminate\Http\Request;

class MouvementtransferController extends Controller
{
       public function index(Request $request)
{
    $query = Mouvementtransfer::with(['produit', 'couleur', 'taille', 'stockOrigine', 'stockDestination']);

    $periode = null;

    if ($request->filled('date')) {
        $query->whereDate('created_at', $request->date);
        $periode = "Le " . date('d/m/Y', strtotime($request->date));
    } elseif ($request->filled('start_date') && $request->filled('end_date')) {
        $query->whereBetween('created_at', [$request->start_date, $request->end_date]);
        $periode = "Du " . date('d/m/Y', strtotime($request->start_date)) . " au " . date('d/m/Y', strtotime($request->end_date));
    }

    $mouvements = $query->latest()->get();

    if ($request->has('pdf')) {
        $pdf = PDF::loadView('mouvementtransfers.pdf', compact('mouvements', 'periode'));
        return $pdf->download('mouvements.pdf');
    }

    return view('mouvementtransfers.index', compact('mouvements', 'periode'));
}

}
