<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\DB;
use ConsoleTVs\Charts\Classes\Chartjs\Chart;
use App\Models\depense;
use App\Models\produit;
use App\Models\role;
use App\Models\reglement_cl;
use App\Models\User;
use App\Models\info;
use App\Models\ville;
use App\Models\statut;
use App\Models\encour;
use App\Models\vente;
use App\Models\client;
use App\Models\catclientfrn;
use App\Models\enattend;
use App\Models\caisse;
use App\Models\detaille_bonlivraison;
use App\Models\hystorique_factur;
use App\Models\bonlivraison;
use App\Models\detaille_vente;
use App\Models\hystoriqprix;
use App\Models\cheque;
use Illuminate\Http\Request;
use \Carbon\Carbon;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }
    public function dash()
    {



        return view('admin.dash');
     
    }

    
    public function dashboarduser(){
  

            // 🟢 1️⃣ Ventes mensuelles
            $ventes = Vente::selectRaw('SUM(prixtotal) as total, MONTH(created_at) as month')
                ->groupBy('month')
                ->orderBy('month')
                ->get();
        
            $months = ['Janvier', 'Février', 'Mars', 'Avril', 'Mai', 'Juin', 'Juillet', 'Août', 'Septembre', 'Octobre', 'Novembre', 'Décembre'];
            $salesData = array_fill(0, 12, 0); // Initialiser les données à 0
        
            foreach ($ventes as $vente) {
                $salesData[$vente->month - 1] = $vente->total;
            }
        
            // 🟢 2️⃣ Produits les plus vendus (depuis detaille_vente)
            $produits = detaille_vente::selectRaw('SUM(quantite) as total, nom')
                ->groupBy('nom')
                ->orderByDesc('total')
                ->limit(5) // Top 5 produits
                ->get();
        
            $produitLabels = $produits->pluck('nom');
            $produitData = $produits->pluck('total');
        
            // 🟢 3️⃣ Clients qui ont le plus acheté
            $clients = Client::selectRaw('SUM(ventes.prixtotal) as total, clients.nom')
                ->join('ventes', 'clients.id', '=', 'ventes.client_id')
                ->groupBy('clients.nom')
                ->orderByDesc('total')
                ->limit(5) // Top 5 clients
                ->get();
        
            $clientLabels = $clients->pluck('nom');
            $clientData = $clients->pluck('total');
        
            return view('admin.dashuser', compact('salesData', 'months', 'produitLabels', 'produitData', 'clientLabels', 'clientData'));
        }
        
        
           
        
 

        
       
   
          
         
   
    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        return view('home');
    }

    public function roles()
    {
        $users = User::with('roles')->get();
        $roles = Role::all();
        return view('users.index', compact('users', 'roles'));
    }

    public function addRole(Request $request)
    {
        $user = User::findOrFail($request->user_id);
        $user->assignRole($request->role);
        return back()->with('success', 'Rôle ajouté avec succès');
    }

    public function updateRoles(Request $request, $id)
    {
        $user = User::findOrFail($id);
        
        // Synchroniser les rôles dans la table pivot `user_roles`
        $user->roles()->sync($request->roles);
    
        return redirect()->route('users.index')->with('success', 'Rôles mis à jour avec succès.');
    }
    

    public function deleteRole(Request $request)
    {
        $user = User::findOrFail($request->user_id);
        $user->roles()->detach();
        return back()->with('success', 'Rôle supprimé avec succès');
    }
  
}
