<?php

namespace App\Http\Controllers;
use App\Models\ville;

use App\Models\catclientfrn;
use App\Models\statut;
use App\Models\fournisseur;
use Illuminate\Http\Request;

class FournisseurController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {  
        
        $villes= ville::all();
        $statuts= statut::all();
   
        $fournisseurs= fournisseur::orderBy('created_at','desc')->paginate(10);
        return view('admin.fournisseurs',['fournisseurs'=>$fournisseurs,
    
        'villes'=>$villes,
       
            'statuts'=>$statuts,
    
    ]);





      



    }
 
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function fournisseurs()
    {
          $fournisseurs= fournisseur::all();
 
    return response()->json(['fournisseurs'=>$fournisseurs]);
    }
    


    public function fournisseurbyid($id)
    {
        $fournisseur= fournisseur::where('id',$id)->first();
 
        return response()->json(['fournisseur'=>$fournisseur]);
    }
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $fournisseur= new fournisseur();
    
        $fournisseur->nom=$request->nom;
        $fournisseur->tele=$request->tele;
        $fournisseur->monton=$request->monton;
        $fournisseur->ville_id=$request->ville;
        $fournisseur->statut_id=$request->statut;
       
        $fournisseur->email=$request->email;
     
        $fournisseur->save();
        return redirect()->back()->with('success', ' bien enregistrer');
       // return response()->json(['fournisseur'=>$fournisseur,'success'=>'success']);
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\fournisseur  $fournisseur
     * @return \Illuminate\Http\Response
     */
    public function show(fournisseur $fournisseur)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\fournisseur  $fournisseur
     * @return \Illuminate\Http\Response
     */
    public function edit(fournisseur $fournisseur)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\fournisseur  $fournisseur
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $fournisseur=fournisseur::where('id',$id)->first();
        $fournisseur->nom=$request->nom;
        $fournisseur->tele=$request->tele;
        $fournisseur->monton=$request->monton;
        $fournisseur->ville_id=$request->ville;
        $fournisseur->statut_id=$request->statut;

        $fournisseur->email=$request->email;
     
        $fournisseur->save();
        return redirect()->back()->with('success', ' bien enregistrer');
return redirect()->back()->with('success', ' bien enregistrer');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\fournisseur  $fournisseur
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $fournisseur=fournisseur::where('id',$id)->first();
        $fournisseur->delete();
        return redirect()->back()->with('success', ' bien supprimer');
    }
}
