<?php

namespace App\Http\Controllers;
use App\Models\detaille_devis;
use App\Models\devis;
use Illuminate\Http\Request;
use \Carbon\Carbon;
use App\Models\hystorique_factur;
class DevisController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('admin.devis');
    }
    public function facturdevis()
    {
        $devis=devis::paginate(10);
        return view('admin.facturdevis',['devis'=>$devis]);
    }


    public function cherchefacturdevis(Request $request)
    {
        // Initialiser la requête
        $query = devis::query();
    
        // Appliquer le filtre par date de début
        if ($request->filled('start_date')) {
            $query->where('created_at', '>=', $request->start_date);
        }
    
        // Appliquer le filtre par date de fin
        if ($request->filled('end_date')) {
            $query->where('created_at', '<=', $request->end_date);
        }
    
        // Appliquer le filtre par référence
        if ($request->filled('reference')) {
            $query->where('id', 'like', '%' . $request->reference . '%');
        }
    
        // Obtenir les résultats paginés
        $devis = $query->orderBy('created_at', 'desc')->paginate(10);
    
        return view('admin.facturdevis',['devis'=>$devis]);
    }



    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
 

        $devis= new devis();
        $devis->user_id=Auth()->user()->id;
        $devis->prixtotal=$request->prixtotal;
        $devis->client_id=$request->idclient; 
   
        $devis->dateecheance= Carbon::now();
 
         $devis->save();
    
         foreach ($request->cart as $item) {
            // Enregistrement d'un produit du panier dans une table associée
            $itemVente = new detaille_devis();
            $itemVente->devis_id = $devis->id;
            $itemVente->produit_id = $item['id'];        // ID du produit
            $itemVente->quantite = $item['quantite'];    // Quantité
            $itemVente->prixvents = $item['prixvente'];   
            $itemVente->x = $item['total'];              // Total
            $itemVente->comme = "er";                    // Commentaire
            $itemVente->prixun = $item['prixun'];  
            $itemVente->nom = $item['nom'];              // Nom du produit
            $itemVente->save();
         }
             
      

           
                   
      

        return redirect()->back()->with('success', ' bien enregistrer');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\devis  $devis
     * @return \Illuminate\Http\Response
     */
    public function show(devis $devis)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\devis  $devis
     * @return \Illuminate\Http\Response
     */
    public function edit(devis $devis)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\devis  $devis
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, devis $devis)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\devis  $devis
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $devis = devis::where('id', $id)->first();
       


        $detaille_devis = detaille_devis::where('devis_id', $devis->id)->get();
        
       foreach ($detaille_devis as $det) {
            $det->delete();
        }
        $devis->delete();

   
 
        return redirect()->back()->with('success', ' bien supprimer');
    }
}
