<?php

namespace App\Http\Controllers;

use App\Models\depense;
use App\Models\caisse;
use App\Models\catdepense;
use Illuminate\Http\Request;

class DepenseController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
   
        
        $depenses=depense::paginate(10); 
      
        return view('admin.depense',['depenses'=>$depenses]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
     
 
     
        $depenses= new depense();
        $depenses->depense=$request->depense;
        $depenses->montant=$request->montant;
   

        $depenses->save();
    
        return redirect()->back()->with('success', ' bien enregistrer');
    }

    public function rechercheDate(Request $request)
{
    $query = depense::query();

    if ($request->filled('date_debut') && $request->filled('date_fin')) {
        $query->whereBetween('created_at', [$request->date_debut, $request->date_fin]);
    }

    $depenses = $query->paginate(10);

    return view('admin.depense', compact('depenses'));
}

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\depense  $depense
     * @return \Illuminate\Http\Response
     */
    public function show(depense $depense)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\depense  $depense
     * @return \Illuminate\Http\Response
     */
    public function edit(depense $depense)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\depense  $depense
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request,$id)
    {
        $depenses=depense::where('id',$id)->first();
        $depenses->depense=$request->depense;
        $depenses->montant=$request->montant;

        $depenses->save();
     
        return redirect()->back()->with('success', ' bien supprimer'); 
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\depense  $depense
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $depense=depense::where('id',$id)->first();
        $depense->delete();
        return redirect()->back()->with('success', ' bien supprimer');
    }
}
