<?php

namespace App\Http\Controllers;

use App\Models\Couleur;
use Illuminate\Http\Request;

class CouleurController extends Controller
{
    public function index()
    {
        $couleurs = Couleur::all();
        return view('couleurs.index', compact('couleurs'));
    }

    public function Couleur()
    {
        $Couleur=Couleur::all();
 
        return response()->json(['Couleur'=>$Couleur]);
    }



    public function store(Request $request)
    {
        $request->validate([
            'couleur' => 'required|string|max:255',
        ]);

        Couleur::create($request->only('couleur'));
        return redirect()->route('couleurs.index')->with('success', 'Couleur ajoutée avec succès');
    }

    public function update(Request $request, Couleur $couleur)
    {
        $request->validate([
            'couleur' => 'required|string|max:255',
        ]);

        $couleur->update($request->only('couleur'));
        return redirect()->route('couleurs.index')->with('success', 'Couleur modifiée avec succès');
    }

    public function destroy(Couleur $couleur)
    {
        $couleur->delete();
        return redirect()->route('couleurs.index')->with('success', 'Couleur supprimée avec succès');
    }
}
