<?php

namespace App\Http\Controllers;
use App\Models\ville;
use App\Models\client;
use App\Models\vente;
use App\Models\catclientfrn;
use App\Models\statut;
use App\Models\caisse;
use App\Models\reglement_cl;
use Illuminate\Http\Request;
Use \Carbon\Carbon;
use App\Models\hystorique_factur;
class ClientController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
      
        $clients= client::orderBy('created_at','desc')->paginate(10);
        $villes= ville::all();
        $statuts= statut::all();
      
        $amountSum = client::sum('monton');
        return view('admin.client1',[
            
            'clients'=>$clients,
            'villes'=>$villes,
        
            'statuts'=>$statuts,
            'amountSum'=>$amountSum,
        
        
        ]);
    }
    public function clients()
    {
        $clients= client::all();
 
        return response()->json(['clients'=>$clients]);
    }
    
    public function clientbyid($id)
    {
        $client= client::where('id',$id)->first();
 
        return response()->json(['client'=>$client]);
    }

    public function irrecouvrableclients()
    {
        $clients= client::where('catclientfrn_id',2)->get();
        $clientsum= client::where('catclientfrn_id',2)->sum('monton');
   
 
        return view('admin.irrecouvrableclient',['clients'=>$clients,'clientsum'=>$clientsum]);
    }
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
      
        $client= new client();
    
        $client->nom=$request->nom;
        $client->tele=$request->tele;
        $client->monton=$request->monton;
        $client->ville_id=$request->ville;
        $client->statut_id=$request->statut;
        $client->statut_id=$request->statut;
        $client->adress=$request->adress;
        $client->email=$request->email;
        $client->save();
        return redirect()->back()->with('success', ' bien enregistrer');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\client  $client
     * @return \Illuminate\Http\Response
     */
    public function detaille_client( $id)
    {
        $client= client::find($id);
        $ventes_liquidation =vente::where('client_id',$id)
        ->where('rest','>',0)
        ->orderBy('created_at','desc')->get();
   
        $ventes =vente::where('client_id',$id)->orderBy('created_at','desc')->get();
        $ventes_payer =vente::where('client_id',$id)
        ->where('encour_id',1)
        ->orderBy('created_at','desc')->get();
        $monaie=vente::sum('avance');
        $ventes_nonpayer =vente::where('client_id',$id)
        ->where('encour_id',2)
        ->orderBy('created_at','desc')->get();
        $totalfacture=$ventes->count();
        
        $reglements=reglement_cl::where('client_id',$id)->orderBy('created_at','desc')->get();

        return view('admin.detaille_client',[
            
            'client'=>$client,
            'ventes'=>$ventes,
            'reglements'=>$reglements,
            'ventes_nonpayer'=>$ventes_nonpayer,
            'ventes_payer'=>$ventes_payer,
            'totalfacture'=>$totalfacture,
            'monaie'=>$monaie,
            'ventes_liquidation'=>$ventes_liquidation,
        
        
        ]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\client  $client
     * @return \Illuminate\Http\Response
     */
    public function modifclient(Request $request ,$id)
    {
        $client= client::find($id);
        $client->pourcentage=$request->input('taux');
        $client->update();
        return redirect()->back()->with('success', ' Taux bien modifier');


    }

    public function modiffacture(Request $request ,$id)
    {
      
        $vente= vente::find($id);



        $vente->avance+=$request->monton;
       $vente->rest= $vente->prixtotal-$vente->avance;
       $vente->dateecheance= Carbon::now();
    
       if($vente->rest==0){
        $vente->encour_id=1;
      
       }elseif($vente->rest>0){
        $vente->encour_id=2;
       }
        $vente->update();
     

$client= client::where('id',$vente->client_id)->first();

$client->monton-=$request->monton;

$client->save();
$caisse= new caisse();
        
$caisse->typecasse_id=1;
$caisse->client_id = $vente->client_id;
$caisse->montant = $request->monton;
$caisse->entrer_id = $vente->id;
$caisse->save();
$reglement= new reglement_cl();
$reglement->client_id=$vente->client_id;
$reglement->vente_id=$vente->id;
$reglement->montant=$request->monton;
$reglement->rest=$vente->prixtotal-$vente->avance;
$reglement->observation="rien";

$reglement->save();

        return redirect()->back()->with('success', ' Taux bien modifier');


    }
    
    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\client  $client
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
  
//dd($request->all());

$client=client::where('id',$id)->first();
$client->nom=$request->nom;
$client->tele=$request->tele;
$client->monton=$request->monton;
$client->ville_id=$request->ville;
$client->statut_id=$request->statut;

$client->email=$request->email;

$client->save();
return redirect()->back()->with('success', ' bien enregistrer');


   


    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\client  $client
     * @return \Illuminate\Http\Response
     */













public function liquidation(Request $request, $id)
{
    $clientId = $id;
    $montant = $request->monton;

    // جلب كل الفواتير اللي باقي فيها رصيد
    $ventes = vente::where('client_id', $clientId)->where('rest', '>', 0)->get();

    $client = client::find($clientId);
    if (!$client) {
        return redirect()->back()->with('error', 'Client introuvable.');
    }

    // حالة: ماكينش فاتورة بسالدة متبقية لكن عنده كريدي
    if ($ventes->isEmpty() && $client->monton > 0) {
        $client->monton -= $montant;
        $client->save();

        // إنشاء سجل جديد في الكاش
        $caisse = new caisse();
        $caisse->typecasse_id = 3;
        $caisse->client_id = $clientId;
        $caisse->montant = $montant;
        $caisse->save();

        // إنشاء سجل جديد في الدفع
        $reglement = new reglement_cl();
        $reglement->client_id = $clientId;
        $reglement->montant = $montant;
        $reglement->rest = 0;
        $reglement->observation = "Crédit réglé en totalité.";
        $reglement->save();

        return redirect()->back()->with('success', 'Crédit client réglé avec succès.');
    }

    foreach ($ventes as $vente) {
        if ($montant <= 0) break;

        $resteAvant = $vente->rest;

        if ($resteAvant <= $montant) {
            // دفع كامل الفاتورة
            $montant -= $resteAvant;

            // إضافة في الكاش
            $caisse = new caisse();
            $caisse->typecasse_id = 3;
            $caisse->client_id = $vente->client_id;
            $caisse->montant = $resteAvant;
            $caisse->entrer_id = $vente->id;
            $caisse->save();

            // تعديل الفاتورة
            $vente->avance = $vente->prixtotal;
            $vente->rest = 0;
            $vente->encour_id = 1; // فاتورة مسددة
            $vente->save();

            // تعديل رصيد الكليان
            $client->monton -= $resteAvant;
            $client->save();

            // إضافة سجل الدفع
            $reglement = new reglement_cl();
            $reglement->client_id = $vente->client_id;
            $reglement->vente_id = $vente->id;
            $reglement->montant = $resteAvant;
            $reglement->rest = 0;
            $reglement->observation = "Facture réglée.";
            $reglement->save();
        } else {
            // دفع جزئي
            $vente->rest -= $montant;
            $vente->avance = $vente->prixtotal - $vente->rest;
            $vente->encour_id = 2; // فاتورة جزئيا مسددة
            $vente->save();

            // إضافة في الكاش
            $caisse = new caisse();
            $caisse->typecasse_id = 3;
            $caisse->client_id = $vente->client_id;
            $caisse->montant = $montant;
            $caisse->entrer_id = $vente->id;
            $caisse->save();

            // تعديل رصيد الكليان
            $client->monton -= $montant;
            $client->save();

            // إضافة سجل الدفع
            $reglement = new reglement_cl();
            $reglement->client_id = $vente->client_id;
            $reglement->vente_id = $vente->id;
            $reglement->montant = $montant;
            $reglement->rest = $vente->rest;
            $reglement->observation = "Facture partiellement réglée.";
            $reglement->save();

            $montant = 0; // استهلكنا كل المبلغ
        }
    }

    return redirect()->back()->with('success', 'Les crédits et factures ont été réglés avec succès.');
}



function date(Request $request){
   // dd($request->all());
    $villes= ville::all();
    $statuts= statut::all();
    $catclientfrns= catclientfrn::all();
   $clients= client::whereBetween('created_at',[$request->debut,$request->fin])->get();
   $amountSum = client::whereBetween('created_at',[$request->debut,$request->fin])->sum('monton');
    return  view('admin.client1',[
            
        'clients'=>$clients,
        'villes'=>$villes,
        'statcatclientfrnsuts'=>$catclientfrns,
        'statuts'=>$statuts,
        'amountSum'=>$amountSum
    
    
    ]);
}
    function date_client(Request $request,$id){
      //  dd($request->all());
        $ventes= vente::whereBetween('created_at',[$request->debut,$request->fin])
        -> where('client_id',$id)
        ->orderBy('created_at','desc')->get();
      $client= client::find($id);
        $ventes_payer =vente::where('client_id',$id)
        ->where('encour_id',1)
        ->orderBy('created_at','desc')->get();
        $monaie=vente::sum('avance');
        $ventes_nonpayer =vente::where('client_id',$id)
        ->where('encour_id',2)
        ->orderBy('created_at','desc')->get();
        $totalfacture=$ventes->count();
        
        $reglements=reglement_cl::where('client_id',$id)
     
        ->orderBy('created_at','desc')->get();
     
       
        return view('admin.detaille_client',[
            
            'client'=>$client,
            'ventes'=>$ventes,
            'reglements'=>$reglements,
            'ventes_nonpayer'=>$ventes_nonpayer,
            'ventes_payer'=>$ventes_payer,
            'totalfacture'=>$totalfacture,
            'monaie'=>$monaie,
        
        
        ]);
    }             
            
            
         
         
        



function date2(Request $request){
    $villes= ville::all();
    $statuts= statut::all();
    $catclientfrns= catclientfrn::all();
    $clients= client::all();
    $query= client::query();
    $dateFilter = $request->date_filter;
    switch($dateFilter){
     case 'aujourd_hui':
         $query->whereDate('created_at',Carbon::today());
    
         break;
     case 'hier':
         $query->wheredate('created_at',Carbon::yesterday());
       
         break;
     case 'cette_semaine':
         $query->whereBetween('created_at',[Carbon::now()->startOfWeek(),Carbon::now()->endOfWeek()]);
        
         break;
     case 'semaine_dernier':
         $query->whereBetween('created_at',[Carbon::now()->subWeek(),Carbon::now()]);
    
       
         break;
     case 'ce_mois':
         $query->whereMonth('created_at',Carbon::now()->month);
   
 
         break;
     case 'mois_dernier':
         $query->whereMonth('created_at',Carbon::now()->subMonth()->month);
       
         break;
     case 'cette_annee':
         $query->whereYear('created_at',Carbon::now()->year);
      
         break;
     case 'annee_dernier':
         $query->whereYear('created_at',Carbon::now()->subYear()->year);
       
         break;                       
 }
 $clients=$query->get();

 return response()-> view('admin.client1',[
            
    'clients'=>$clients,
    'villes'=>$villes,
    'statcatclientfrnsuts'=>$catclientfrns,
    'statuts'=>$statuts,



]);
}


public function destroy($id)
{

    $client=client::where('id',$id)->first();
$client->delete();
return redirect()->back()->with('success', ' bien supprimer');

}

}
