<?php

namespace App\Http\Controllers;
use App\Models\produit;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use ConsoleTVs\Charts\Classes\Chartjs\Chart;

class ChartController extends Controller
{
    public function chart()
{
    // Récupérer les 10 premiers produits (ou ajustez cette logique selon vos besoins)
    $products = produit::orderBy('stock', 'desc')->take(10)->get();

    // Préparer les labels et les données pour le graphique
    $labels = $products->pluck('nom')->toArray(); // Récupérer les noms des produits
    $quantities = $products->pluck('stock')->toArray(); // Récupérer les quantités des produits

    // Créer le graphique des produits par stock
    $chart1 = new \ConsoleTVs\Charts\Classes\Chartjs\Chart;
    $chart1->title('Quantités des 10 premiers produits')
           ->labels($labels)
           ->dataset('Quantité des produits', 'bar', $quantities)
           ->color(['#ff0000', '#00ff00', '#0000ff', '#ff9900', '#9966ff', '#33cc33', '#ff6600', '#cccccc', '#ff6666', '#3399ff'])
           ->backgroundColor('#f0f0f0');
    $chart1->options([
        'responsive' => true,
        'maintainAspectRatio' => false,
        'width' => 400,
        'height' => 300,
    ]);

    // Récupérer les ventes mensuelles
    $ventes = DB::table('ventes')
                ->selectRaw('MONTH(created_at) as mois, SUM(prixtotal) as total')
                ->groupBy('mois')
                ->orderBy('mois')
                ->get();

    $mois = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'];
    $ventesMensuelles = array_fill(0, 12, 0);

    foreach ($ventes as $vente) {
        $ventesMensuelles[$vente->mois - 1] = $vente->total;
    }

    // Créer le graphique des ventes mensuelles
    $chart2 = new Chart();
    $chart2->labels($mois);
    $chart2->dataset('Ventes Mensuelles', 'line', $ventesMensuelles)
           ->color('#007bff')
           ->backgroundColor('rgba(0, 123, 255, 0.3)');

    // Récupérer les paiements payés et impayés
    $paiements = DB::table('ventes')
                    ->selectRaw('encour_id, COUNT(*) as total')
                    ->groupBy('encour_id')
                    ->get();

    $totals = [1 => 0, 2 => 0];

    foreach ($paiements as $paiement) {
        $totals[$paiement->encour_id] = $paiement->total;
    }

    // Créer le graphique des paiements
    $chart3 = new Chart();
    $chart3->labels(['Payé', 'Impayé']);
    $chart3->dataset('Paiements', 'pie', [$totals[1], $totals[2]])
           ->backgroundColor(['#28a745', '#dc3545'])
           ->color(['#ffffff', '#ffffff']);

    // Récupérer les 10 produits les plus vendus
    $produits = DB::table('detaille_ventes')
                  ->selectRaw('produit_id, SUM(prixvents) as total_ventes')
                  ->groupBy('produit_id')
                  ->orderByDesc('total_ventes')
                  ->take(10)
                  ->get();

    $labels2 = [];
    $data2 = [];

    foreach ($produits as $produit) {
        $nomProduit = DB::table('produits')->where('id', $produit->produit_id)->value('nom');
        $labels2[] = $nomProduit ?? 'Produit ID ' . $produit->produit_id;
        $data2[] = $produit->total_ventes;
    }

    // Créer le graphique des produits les plus vendus
    $chart4 = new Chart();
    $chart4->labels($labels2);
    $chart4->dataset('Produits les plus vendus', 'bar', $data2)
           ->color('#17a2b8')
           ->backgroundColor('rgba(23, 162, 184, 0.5)');

    // Retourner la vue avec les graphiques
    return view('admin.chart', compact('chart1', 'chart2', 'chart3', 'chart4'));
}
}
