<?php

namespace App\Http\Controllers;

use App\Models\caisse;
use Illuminate\Http\Request;
use Carbon\Carbon; 

class CaisseController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
   // Assurez-vous d'importer Carbon

    public function index()
    {
       
        
        // Obtenir la date du jour
        $today = Carbon::today();
    
        // Filtrer les enregistrements pour la date actuelle
        $caisse = caisse::whereDate('created_at', $today)
            ->orderBy('created_at', 'desc')
            ->get();
    
        // Calculer les totaux pour la journée
        $sumentrer = caisse::whereDate('created_at', $today)->sum('entrer');
        $sumsortie = caisse::whereDate('created_at', $today)->sum('srtie');
    
        return view('admin.caisse', [
            'caisse' => $caisse,
            'sumentrer' => $sumentrer,
            'sumsortie' => $sumsortie,
        ]);
    }
    

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\caisse  $caisse
     * @return \Illuminate\Http\Response
     */
    public function show(caisse $caisse)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\caisse  $caisse
     * @return \Illuminate\Http\Response
     */
    public function edit(caisse $caisse)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\caisse  $caisse
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, caisse $caisse)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\caisse  $caisse
     * @return \Illuminate\Http\Response
     */
    public function destcaisse($id)
    {
        $caisse=caisse::where('id', $id)->first();
        $caisse->delete();
    }
}
