<?php

namespace App\Http\Controllers;
use App\Models\produit;
use App\Models\stock;
use App\Models\encour;
use App\Models\detaille_boncommande;
use App\Models\boncommande;
use \Carbon\Carbon;
use App\Models\hystorique_factur;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
class BoncommandeController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('admin.commande');
    }
    public function facturboncommande()
    {
        $boncommandes=boncommande::paginate(10);
        return view('admin.facturecommande',['boncommandes'=>$boncommandes]);
    }



    public function cherchefacturcommande(Request $request)
    {
        // Initialiser la requête
        $query = boncommande::query();
    
        // Appliquer le filtre par date de début
        if ($request->filled('start_date')) {
            $query->where('created_at', '>=', $request->start_date);
        }
    
        // Appliquer le filtre par date de fin
        if ($request->filled('end_date')) {
            $query->where('created_at', '<=', $request->end_date);
        }
    
        // Appliquer le filtre par référence
        if ($request->filled('reference')) {
            $query->where('id', 'like', '%' . $request->reference . '%');
        }
    
        // Obtenir les résultats paginés
        $boncommandes = $query->orderBy('created_at', 'desc')->paginate(10);
    
        return view('admin.facturecommande',['boncommandes'=>$boncommandes]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
              // Créer une nouvelle vente
             
                $boncommande= new boncommande();
              $boncommande->user_id = Auth::user()->id;          // ID de l'utilisateur connecté
              $boncommande->prixtotal = $request->prixtotal;     // Prix total envoyé depuis Vue.js
              $boncommande->fournisseur_id = $request->idfournisseur;       // Identifiant du client
         // Total hors taxe
          
              // Sauvegarder la vente
              $boncommande->save();
          
              // Traitement du panier des articles
              foreach ($request->cart as $item) {
                  // Enregistrement d'un produit du panier dans une table associée
                  $detaille_boncommande = new detaille_boncommande();
                  $detaille_boncommande->boncommande_id = $boncommande->id;
                  $detaille_boncommande->produit_id = $item['id'];        // ID du produit
                  $detaille_boncommande->quantite = $item['quantite'];    // Quantité
                  $detaille_boncommande->prixvents = $item['prixvente'];   
                  $detaille_boncommande->x= $item['total']; 
                  $detaille_boncommande->comme = "er";                    // Commentaire
                  $detaille_boncommande->prixun = $item['prixun'];  
                  $detaille_boncommande->nom = $item['nom'];                // Total
                        // Nom du produit
                  $detaille_boncommande->save();
          
           
      }
          
          
    
       
       
              return response()->json(['message' => 'Vente ajoutée avec succès'], 200);
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\boncommande  $boncommande
     * @return \Illuminate\Http\Response
     */
    public function show(boncommande $boncommande)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\boncommande  $boncommande
     * @return \Illuminate\Http\Response
     */
    public function edit(boncommande $boncommande)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\boncommande  $boncommande
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, boncommande $boncommande)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\boncommande  $boncommande
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $boncommande = boncommande::where('id', $id)->first();
       
      

        $detaille_boncommande = detaille_boncommande::where('boncommande_id', $boncommande->id)->get();
        
       foreach ($detaille_boncommande as $det) {
            $det->delete();
        }
        $boncommande->delete();

   
 
        return redirect()->back()->with('success', ' bien supprimer');
    }
}
