<?php

namespace App\Http\Controllers;
use App\Models\produit;
use App\Models\stock;
use App\Models\caisse;
use App\Models\encour;
use App\Models\achat;
use App\Models\detaille_achat;
use Illuminate\Http\Request;
use App\Models\hystorique_factur;
use \Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;

class AchatController extends Controller

{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('admin.achat');
    }
    public function facturachat()


    {
        $achats=achat::orderBy('created_at','desc')->paginate(10);
        $hystorique_factur=hystorique_factur::where('typecasse_id',4)->get();
        return view('admin.facturachat',['achats'=>$achats,'hystorique_factur'=>$hystorique_factur]);
    }

    public function cherchefacturachat(Request $request)
    {
        // Initialiser la requête
        $query = achat::query();
    
        // Appliquer le filtre par date de début
        if ($request->filled('start_date')) {
            $query->where('created_at', '>=', $request->start_date);
        }
    
        // Appliquer le filtre par date de fin
        if ($request->filled('end_date')) {
            $query->where('created_at', '<=', $request->end_date);
        }
    
        // Appliquer le filtre par référence
        if ($request->filled('reference')) {
            $query->where('id', 'like', '%' . $request->reference . '%');
        }
    
        // Obtenir les résultats paginés
        $achats = $query->orderBy('created_at', 'desc')->paginate(10);
    
        // Charger les données historiques
        $hystorique_factur = hystorique_factur::where('typecasse_id', 4)->get();
    
        // Retourner la vue avec les données filtrées
        return view('admin.facturachat', [
            'achats' => $achats,
            'hystorique_factur' => $hystorique_factur
        ]);
    }
    







    public function modif_achat(Request $request)
    {


            $id = $request->idachat;
            $achats = achat::where('id', $id)->first();
            $detaille_achat = detaille_achat::where('achat_id', $id)->get();
            return view('admin.modif_achat',['achats'=>$achats,'detaille_achat' => $detaille_achat]);
            
    }


    public function modife_achat($id)
    {
        $achats = achat::where('id', $id)->first();
        $detaille_achat = detaille_achat::where('achat_id', $id)->with('produit')->get();
       


        return response()->json(['achats' => $achats, 'detaille_achat' => $detaille_achat]);
    }
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function storetest(Request $request)
    { /*
        $caisse= new caisse();
        $caisse->entrer=0;
        $caisse->srtie=$request->prixtotal;
        $caisse->justif="achat facture n 20";
        $caisse->save();*/

      $data = json_decode($request->cart,true);

//dd($request->lieustock_id);
  
        $achat= new achat();
        $achat->user_id=Auth()->user()->id;
        $achat->prixtotal=$request->prixtotal;
        $achat->lieustock_id=$request->lieustock_id;
        
        
        $achat->fournisseur_id=$request->fournisseur_id;
    
    
    
         $achat->save();


         foreach($data  as $req=>$key){
            $produit1=produit::where('id',$data[$req]['id'])->first();
            if($produit1){
              $produit1->stock+=$data[$req]['quantite'];
          $produit1->save();  
          $stock= new stock();
          $stock->user_id=Auth()->user()->id;
          $stock->produit_id=$produit1->id;
          $stock->mouvement_id=1;
          $stock->qty=$data[$req]['quantite'];
         $stock->save();
          $detaille_achat=new detaille_achat();
          $detaille_achat->achat_id=$achat->id;
          $detaille_achat->produit_id=$data[$req]['id'];
          $detaille_achat->prixachat=$data[$req]['prixun'];
          $detaille_achat->qty=$data[$req]['quantite'];
          $detaille_achat->total=$data[$req]['x'];
          $detaille_achat->save();
            }else{
                $path = "img/image-".time(). $data[$req]['id'].".png";
           
                $data_img= explode( ',', $data[$req]['img']);
                
             $image = file_put_contents($path,base64_decode($data_img[1]));
                $produit= new produit();
                $produit->user_id=Auth()->user()->id;
                $produit->nom=$data[$req]['nom'];
           
                $produit->fournisseur_id=$data[$req]['fournisseur_id'];
               
                $produit->lieustock_id=$data[$req]['lieustock_id'];
                $produit->topcat_id=$data[$req]['topcat_id'];
              
                $produit->prixun=$data[$req]['prixun'];
                $produit->prixvents=$data[$req]['prixvents'];


                      $produit->long=125;
                $produit->larg=180;
                $produit->eps=125;
          
    
                $produit->stock=$data[$req]['quantite'];
                $produit->datemajoration=date('Y-m-d H:i:s');
                $produit->img=$path;
                $produit->ref= 2;
                
                $produit->save();
                if( $produit->save()){
                    $stock= new stock();
                    $stock->user_id=Auth()->user()->id;
                    $stock->produit_id=$produit->id;
                    $stock->mouvement_id=1;
                    $stock->qty=$data[$req]['quantite'];
                   $stock->save();
                
             }
             $detaille_achat=new detaille_achat();
             $detaille_achat->achat_id=$achat->id;
             $detaille_achat->produit_id=$produit->id;
             $detaille_achat->prixachat=$data[$req]['prixun'];
             $detaille_achat->qty=$data[$req]['quantite'];
             $detaille_achat->total=$data[$req]['x'];
             $detaille_achat->save();
            }


       
         }
       
      
     
         
          

  

  

                





   
   
 
       
   
     

            
            }
            
     
          

     

       

            
            
 
    
  
                
                    
        
                 





    public function io(Request $request)
    {
 














        $achat= new achat();
        $achat->user_id=Auth()->user()->id;
        $achat->prixtotal=$request->prixtotal;
        $achat->fournisseur_id=$request->fournisseur;
        $achat->modepayement_id=$request->idmod;
        $achat->dateecheance=$request->dateecheance;
        $achat->encour_id=1;
        $achat->avance=1;
        $achat->rest=1;
         $achat->save();

         if($achat->save()){
            foreach($request->id as $req=>$key){
                $produit1=produit::where('id',$request->id[$req])->first();
                if($produit1){
                    $detaille_achat=new detaille_achat();
                    $detaille_achat->achat_id=$achat->id;
                    $detaille_achat->produit_id=$request->id[$req];
                    $detaille_achat->save();
                     $produit1->stock+=$request->qty[$req];
                $produit1->save();    
                }else{
                    $produit= new produit();
                    $produit->user_id=Auth()->user()->id;
                    $produit->nom='nom';
                    $produit->codebar="undifind";
                    $produit->ref=$produit->id;
                    $produit->gain=2;
                    $produit->fournisseur_id=1;
                   
                    $produit->lieustock_id=1;
                    $produit->topcat_id=1;
                    $produit->prixun=22;
                    $produit->prixvents=33;
                    $produit->minqty=2;
                    $produit->qty=$request->qty[$req];
                    $produit->stock=$request->qty[$req];//quntite
                    $produit->datemajoration=date('Y-m-d H:i:s');
                    $produit->img='xx';
                    
                    $produit->save();
                    $detaille_achat1=new detaille_achat();
                    $detaille_achat1->achat_id=$achat->id;
                    $detaille_achat1->produit_id=$produit->id;
                    $detaille_achat1->save();
                }
             

       


          
                $stock= new stock();
                $stock->user_id=Auth()->user()->id;
                $stock->produit_id=$produit->id;
                $stock->mouvement_id=2;
                $stock->qty+=$request->qty[$req];
                $stock->save();
             }


               
                   
        }
            
              
  

        return redirect()->back()->with('success', ' bien enregistrer');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\achat  $achat
     * @return \Illuminate\Http\Response
     */
    public function modifier_achat(Request $request, $id)
    {
    
        $achat = achat::where('id', $id)->first();
        $data = json_decode($request->cart,true);

//dd($request->lieustock_id);
  
    
        $achat->user_id=Auth()->user()->id;
        $achat->prixtotal=$request->prixtotal;
        $achat->lieustock_id=$request->lieustock_id;
        $achat->fournisseur_id=$request->fournisseur_id;
        $achat->save();
        
              //trasabilite
              $hystorique_factur= new hystorique_factur();
              $hystorique_factur->facture_id = $achat->id;
              $hystorique_factur->user_id=Auth()->user()->id;
              $hystorique_factur->catfacture_id=2; // 1 cree 2 modifier 3supprimer;
              $hystorique_factur->typecasse_id=4;// 1 vente 2 avoir 3reglement 4 achat 5 commande 6 devis;
              $hystorique_factur->save();
    
    
         
         foreach($data  as $req=>$key){
           
            $productIsExist = $achat->detaille_achat()->where('produit_id',$data[$req]['id'])->first();
            logger($productIsExist);   
            if($productIsExist){
            logger($productIsExist);   
                $produit1=produit::where('id',$data[$req]['id'])->first();
                $produit1->stock = ($produit1->stock-$productIsExist->qty)+$data[$req]['quantite'];
                $produit1->save();
                if( $produit1->save()){
                    $stock= new stock();
                    $stock->user_id=Auth()->user()->id;
                    $stock->produit_id=$produit1->id;
                    $stock->mouvement_id=1;
                    $stock->qty=$data[$req]['quantite'];
                   $stock->save();
                   $stock2= new stock();
                   $stock2->user_id=Auth()->user()->id;
                   $stock2->produit_id=$produit1->id;
                   $stock2->mouvement_id=2;
                   $stock2->qty=$productIsExist->qty;
                  $stock2->save();
                
             }
            $detaille_achat = $productIsExist;
            $detaille_achat->achat_id=$achat->id;
            $detaille_achat->produit_id=$data[$req]['id'];
            $detaille_achat->qty=$data[$req]['quantite'];
            $detaille_achat->prixachat=$data[$req]['prixun'];
            $detaille_achat->total=$data[$req]['x'];
            $detaille_achat->save();
         }else{
            //ajouter au stock
            $path = "img/image-".time(). $data[$req]['id'].".png";
           
            $data_img= explode( ',', $data[$req]['img']);
            
         $image = file_put_contents($path,base64_decode($data_img[1]));
            $produit= new produit();
            $produit->user_id=Auth()->user()->id;
            $produit->nom=$data[$req]['nom'];
       
            $produit->fournisseur_id=$data[$req]['fournisseur_id'];
           
            $produit->lieustock_id=$data[$req]['lieustock_id'];
            $produit->topcat_id=$data[$req]['topcat_id'];
          
            $produit->prixun=$data[$req]['prixun'];
            $produit->prixvents=$data[$req]['prixvents'];
      

            $produit->stock=$data[$req]['quantite'];
            $produit->datemajoration=date('Y-m-d H:i:s');
            $produit->img=$path;
            $produit->ref= 2;
            
            $produit->save();
            if( $produit->save()){
                $stock= new stock();
                $stock->user_id=Auth()->user()->id;
                $stock->produit_id=$produit->id;
                $stock->mouvement_id=1;
                $stock->qty=$data[$req]['quantite'];
               $stock->save();
            
         }
            $achat->detaille_achat()->create([
                'produit_id' => $produit->id,
                'qty' => $data[$req]['quantite'],
                'prixachat' => $data[$req]['prixun'],
                'total' => $data[$req]['x'],
          
            ]);
        }
    }
  




     
    
    }
    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\achat  $achat
     * @return \Illuminate\Http\Response
     */
    public function edit(achat $achat)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\achat  $achat
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
              // Créer une nouvelle vente
             
                $achat= new achat();
              $achat->user_id = Auth::user()->id;          // ID de l'utilisateur connecté
              $achat->prixtotal = $request->prixtotal;     // Prix total envoyé depuis Vue.js
              $achat->fournisseur_id = $request->idfournisseur;      // Identifiant du client
              $achat->modepayement_id = $request->modepayement_id; // Mode de paiement
              $achat->dateecheance = Carbon::now();        // Date d'échéance (actuelle)
              $achat->lieustock_id = 1;                     // Identifiant du lieu de stock
              $achat->comment = "bo";                       // Commentaire (fixé arbitrairement)
              $achat->encour_id = 1; 
                   // Montant restant (à partir de la requête)
          
              // Champs relatifs à la TVA, remise et totals
              $achat->tva = $request->tva;                  // TVA envoyée depuis Vue.js
              $achat->remise = $request->remise;            // Remise envoyée depuis Vue.js
              $achat->totalremise = $request->totalremise;  // Total des remises
              $achat->totaltva = $request->totaltva;        // Total TVA
              $achat->totalhtc = $request->totalhtc;        // Total hors taxe
          
              // Sauvegarder la vente
              $achat->save();
          
              // Traitement du panier des articles
              foreach ($request->cart as $item) {
                  // Enregistrement d'un produit du panier dans une table associée
                  $itemVente = new detaille_achat();
                  $itemVente->achat_id = $achat->id;
                  $itemVente->produit_id = $item['id'];        // ID du produit
                  $itemVente->qty = $item['quantite'];    // Quantité
                  $itemVente->prixachat = $item['prixvente'];   
                  $itemVente->total= $item['total'];              // Total
                        // Nom du produit
                  $itemVente->save();
          
                  // Mise à jour du stock du produit
                  $produit = produit::where('id', $item['id'])->first();
                  $produit->stock += $item['quantite'];
                  $produit->save();

                  $produit->save();
if( $produit->save()){
    $stock= new stock();
    $stock->user_id=Auth()->user()->id;
    $stock->produit_id=$produit->id;
    $stock->mouvement_id=1;
    $stock->qty= $item['quantite'];
$stock->save();
}  
              }
          
          
    
       
       
              return response()->json(['message' => 'Vente ajoutée avec succès'], 200);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\achat  $achat
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $achat = achat::where('id', $id)->first();


        $detaille_achat = detaille_achat::where('achat_id', $achat->id)->get();
        
        foreach ($detaille_achat as $det) {

            $produit = produit::where('id', $det->produit_id)->first();
            $produit->stock -= $det->qty;
            $produit->save();
            $stock2 = new stock();
            $stock2->user_id = Auth()->user()->id;
            $stock2->produit_id = $produit->id;
            $stock2->mouvement_id = 2; //
            $stock2->qty = $det->qty;
            $stock2->save();
        }
       foreach ($detaille_achat as $det) {
            $det->delete();
        }
        $achat->delete();
 
        return redirect()->back()->with('success', ' bien supprimer');
    }


    public function deletligneachat($id)
    {
        
        $detaille_achat = detaille_achat::where('produit_id', $id)->first();
        if($detaille_achat) {
                   $produit = produit::where('id', $id)->first();
        $produit->stock -= $detaille_achat->qty;
        $produit->save();
        $stock2 = new stock();
        $stock2->user_id = Auth()->user()->id;
        $stock2->produit_id = $produit->id;
        $stock2->mouvement_id = 2; //
        $stock2->qty = $detaille_achat->qty;
        $stock2->save();
  

        $detaille_achat->delete();
        }else{
            return;
        }

 
    }
}
